/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import me.dreamvoid.miraimc.api.MiraiBot;
import me.dreamvoid.miraimc.bukkit.BukkitPlugin;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.Utils;
import net.mamoe.mirai.utils.BotConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MiraiAutoLogin {
    private final BukkitPlugin plugin;
    private final Logger Logger;
    private static File AutoLoginFile;
    public static MiraiAutoLogin Instance;

    public MiraiAutoLogin(BukkitPlugin plugin) {
        this.plugin = plugin;
        this.Logger = Utils.logger;
        Instance = this;
    }

    public void loadFile() {
        File MiraiDir = !Config.General.MiraiWorkingDir.equals("default") ? new File(Config.General.MiraiWorkingDir) : new File(Config.PluginDir, "MiraiBot");
        File ConsoleDir = new File(MiraiDir, "config/Console");
        if (!ConsoleDir.exists() && !ConsoleDir.mkdirs()) {
            throw new RuntimeException("Failed to create folder " + ConsoleDir.getPath());
        }
        AutoLoginFile = new File(ConsoleDir, "AutoLogin.yml");
        if (!AutoLoginFile.exists()) {
            try {
                if (!AutoLoginFile.createNewFile()) {
                    throw new RuntimeException("Failed to create folder " + AutoLoginFile.getPath());
                }
                String defaultText = "accounts: " + System.getProperty("line.separator");
                File writeName = AutoLoginFile;
                try (FileWriter writer = new FileWriter(writeName);
                     BufferedWriter out = new BufferedWriter(writer);){
                    out.write(defaultText);
                    out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<Map<?, ?>> loadAutoLoginList() {
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)AutoLoginFile);
        return data.getMapList("accounts");
    }

    public void doStartUpAutoLogin() {
        Runnable thread = () -> {
            this.Logger.info("[AutoLogin] Starting auto login task.");
            for (Map<?, ?> map : this.loadAutoLoginList()) {
                BotConfiguration.MiraiProtocol Protocol;
                Map password = (Map)map.get("password");
                Map configuration = (Map)map.get("configuration");
                long Account = Long.parseLong(String.valueOf(map.get("account")));
                if (Account == 123456L) continue;
                String Password = password.get("value").toString();
                try {
                    Protocol = BotConfiguration.MiraiProtocol.valueOf((String)configuration.get("protocol").toString().toUpperCase());
                }
                catch (IllegalArgumentException ignored) {
                    this.Logger.warning("[AutoLogin] Unknown protocol " + configuration.get("protocol").toString().toUpperCase() + ", using ANDROID_PHONE instead.");
                    Protocol = BotConfiguration.MiraiProtocol.ANDROID_PHONE;
                }
                this.Logger.info("[AutoLogin] Auto login bot account: " + Account + " Protocol: " + Protocol.name());
                MiraiBot.doBotLogin(Account, Password, Protocol);
            }
        };
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, thread);
    }

    public boolean addAutoLoginBot(long Account, String Password, String Protocol) {
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)AutoLoginFile);
        List list = data.getMapList("accounts");
        HashMap<String, Serializable> account = new HashMap<String, Serializable>();
        account.put("account", Long.valueOf(Account));
        HashMap<String, String> password = new HashMap<String, String>();
        password.put("kind", "PLAIN");
        password.put("value", Password);
        account.put("password", password);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("protocol", Protocol.toUpperCase());
        configuration.put("device", "device.json");
        account.put("configuration", configuration);
        list.add(account);
        data.set("accounts", (Object)list);
        try {
            data.save(AutoLoginFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean delAutoLoginBot(long Account) {
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)AutoLoginFile);
        List list = data.getMapList("accounts");
        for (Map bots : list) {
            if (Long.parseLong(String.valueOf(bots.get("account"))) != Account) continue;
            list.remove(bots);
            break;
        }
        data.set("accounts", (Object)list);
        try {
            data.save(AutoLoginFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

