/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import me.dreamvoid.miraimc.api.MiraiBot;
import me.dreamvoid.miraimc.bukkit.BukkitConfig;
import me.dreamvoid.miraimc.bukkit.Events;
import me.dreamvoid.miraimc.bukkit.MiraiAutoLogin;
import me.dreamvoid.miraimc.bukkit.MiraiEvent;
import me.dreamvoid.miraimc.bukkit.MiraiEventLegacy;
import me.dreamvoid.miraimc.bukkit.MiraiHttpAPIResolver;
import me.dreamvoid.miraimc.bukkit.commands.MiraiCommand;
import me.dreamvoid.miraimc.bukkit.commands.MiraiMcCommand;
import me.dreamvoid.miraimc.bukkit.commands.MiraiVerifyCommand;
import me.dreamvoid.miraimc.bukkit.utils.Metrics;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.MiraiLoginSolver;
import me.dreamvoid.miraimc.internal.PluginUpdate;
import me.dreamvoid.miraimc.internal.Utils;
import me.dreamvoid.miraimc.internal.classloader.MiraiLoader;
import me.dreamvoid.miraimc.webapi.Info;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitPlugin
extends JavaPlugin {
    private MiraiEvent MiraiEvent;
    public MiraiAutoLogin MiraiAutoLogin;

    public void onLoad() {
        try {
            Utils.setLogger(this.getLogger());
            Utils.setClassLoader(this.getClassLoader());
            new BukkitConfig(this).loadConfig();
            if (Config.General.MiraiCoreVersion.equalsIgnoreCase("latest")) {
                MiraiLoader.loadMiraiCore();
            } else if (Config.General.MiraiCoreVersion.equalsIgnoreCase("stable")) {
                MiraiLoader.loadMiraiCore(MiraiLoader.getStableVersion(this.getDescription().getVersion()));
            } else {
                MiraiLoader.loadMiraiCore(Config.General.MiraiCoreVersion);
            }
            this.MiraiEvent = !Config.General.LegacyEventSupport ? new MiraiEvent() : new MiraiEventLegacy();
            this.MiraiAutoLogin = new MiraiAutoLogin(this);
        }
        catch (Exception e) {
            this.getLogger().warning("An error occurred while loading plugin.");
            e.printStackTrace();
        }
    }

    public void onEnable() {
        try {
            Class.forName("cpw.mods.modlauncher.Launcher");
            this.getLogger().severe("\u4efb\u4f55Forge\u670d\u52a1\u7aef\u5747\u4e0d\u53d7MiraiMC\u652f\u6301\uff08\u5982Catserver\u3001Loliserver\uff09\uff0c\u8bf7\u5c3d\u91cf\u66f4\u6362\u5176\u4ed6\u670d\u52a1\u7aef\u4f7f\u7528\uff01");
            this.getLogger().severe("\u4f5c\u8005\u4e0d\u4f1a\u5904\u7406\u4efb\u4f55\u4f7f\u7528\u4e86Forge\u670d\u52a1\u7aef\u5bfc\u81f4\u7684\u95ee\u9898\u3002");
            this.getLogger().severe("\u517c\u5bb9\u6027\u62a5\u544a: https://wiki.miraimc.dreamvoid.me/troubleshoot/compatibility-report");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.getLogger().info("Mirai working dir: " + Config.General.MiraiWorkingDir);
        if (Config.General.AddProperties.MiraiNoDesktop) {
            System.setProperty("mirai.no-desktop", "MiraiMC");
        }
        if (Config.General.AddProperties.MiraiSliderCaptchaSupported) {
            System.setProperty("mirai.slider.captcha.supported", "MiraiMC");
        }
        this.getLogger().info("Starting Mirai-Events listener.");
        this.MiraiEvent.startListenEvent();
        this.getLogger().info("Loading auto-login file.");
        this.MiraiAutoLogin.loadFile();
        this.MiraiAutoLogin.doStartUpAutoLogin();
        this.getLogger().info("Registering commands.");
        this.getCommand("mirai").setExecutor((CommandExecutor)new MiraiCommand(this));
        this.getCommand("mirai").setTabCompleter((TabCompleter)new MiraiCommand(this));
        this.getCommand("miraimc").setExecutor((CommandExecutor)new MiraiMcCommand(this));
        this.getCommand("miraimc").setTabCompleter((TabCompleter)new MiraiMcCommand(this));
        this.getCommand("miraiverify").setExecutor((CommandExecutor)new MiraiVerifyCommand());
        if (Config.Bot.LogEvents) {
            this.getLogger().info("Registering events.");
            Bukkit.getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        }
        switch (Config.Database.Type.toLowerCase()) {
            default: {
                this.getLogger().info("Initializing SQLite database.");
                try {
                    Utils.initializeSQLite();
                }
                catch (ClassNotFoundException | SQLException e) {
                    this.getLogger().warning("Failed to initialize SQLite database, reason: " + e);
                }
                break;
            }
            case "mysql": {
                this.getLogger().info("Initializing MySQL database.");
                Utils.initializeMySQL();
            }
        }
        if (Config.General.AllowBStats && !this.getDescription().getVersion().contains("dev")) {
            this.getLogger().info("Initializing bStats metrics.");
            int pluginId = 11534;
            new Metrics(this, pluginId);
        }
        if (Config.General.CheckUpdate && !this.getDescription().getVersion().contains("dev")) {
            new BukkitRunnable(){

                public void run() {
                    BukkitPlugin.this.getLogger().info("Checking update...");
                    try {
                        String version;
                        PluginUpdate fetch = new PluginUpdate();
                        String string = version = !BukkitPlugin.this.getDescription().getVersion().contains("-") ? fetch.getLatestRelease() : fetch.getLatestPreRelease();
                        if (fetch.isBlocked(BukkitPlugin.this.getDescription().getVersion())) {
                            BukkitPlugin.this.getLogger().severe("\u5f53\u524d\u7248\u672c\u5df2\u505c\u7528\uff0c\u7ee7\u7eed\u4f7f\u7528\u5c06\u4e0d\u4f1a\u5f97\u5230\u4f5c\u8005\u7684\u4efb\u4f55\u652f\u6301\uff01");
                            BukkitPlugin.this.getLogger().severe("\u8bf7\u7acb\u523b\u66f4\u65b0\u5230\u6700\u65b0\u7248\u672c: " + version);
                            BukkitPlugin.this.getLogger().severe("\u4eceGithub\u4e0b\u8f7d\u66f4\u65b0: https://github.com/DreamVoid/MiraiMC/releases/latest");
                        } else if (!BukkitPlugin.this.getDescription().getVersion().equals(version)) {
                            BukkitPlugin.this.getLogger().info("\u5df2\u627e\u5230\u65b0\u7684\u63d2\u4ef6\u66f4\u65b0\uff0c\u6700\u65b0\u7248\u672c: " + version);
                            BukkitPlugin.this.getLogger().info("\u4eceGithub\u4e0b\u8f7d\u66f4\u65b0: https://github.com/DreamVoid/MiraiMC/releases/latest");
                        } else {
                            BukkitPlugin.this.getLogger().info("You are using the latest version!");
                        }
                    }
                    catch (IOException e) {
                        BukkitPlugin.this.getLogger().warning("An error occurred while fetching the latest version, reason: " + e);
                    }
                }
            }.runTaskAsynchronously((Plugin)this);
        }
        if (Config.General.EnableHttpApi) {
            this.getLogger().info("Initializing HttpAPI async task.");
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new MiraiHttpAPIResolver(this), 0L, Config.HttpApi.MessageFetch.Interval);
        }
        if (!Config.General.DisableSafeWarningMessage) {
            this.getLogger().warning("\u786e\u4fdd\u60a8\u6b63\u5728\u4f7f\u7528\u5f00\u6e90\u7684MiraiMC\u63d2\u4ef6\uff0c\u672a\u77e5\u6765\u6e90\u7684\u63d2\u4ef6\u53ef\u80fd\u4f1a\u76d7\u53d6\u60a8\u7684\u8d26\u53f7\uff01");
            this.getLogger().warning("\u8bf7\u59cb\u7ec8\u4eceGithub\u6216\u4f5c\u8005\u6307\u5b9a\u7684\u5176\u4ed6\u9014\u5f84\u4e0b\u8f7d\u63d2\u4ef6: https://github.com/DreamVoid/MiraiMC");
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    List<String> announcement = Info.init().announcement;
                    if (announcement != null) {
                        BukkitPlugin.this.getLogger().info("========== [ MiraiMC \u516c\u544a\u7248 ] ==========");
                        announcement.forEach(s -> BukkitPlugin.this.getLogger().info((String)s));
                        BukkitPlugin.this.getLogger().info("=======================================");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.runTaskLaterAsynchronously((Plugin)this, 40L);
        this.getLogger().info("All tasks done. Welcome to use MiraiMC!");
    }

    public void onDisable() {
        if (this.MiraiEvent != null) {
            this.getLogger().info("Stopping bot event listener.");
            this.MiraiEvent.stopListenEvent();
        }
        this.getLogger().info("Closing all bots");
        MiraiLoginSolver.cancelAll();
        Object object = MiraiBot.getOnlineBots().iterator();
        while (object.hasNext()) {
            long bots = object.next();
            MiraiBot.getBot(bots).close();
        }
        switch (Config.Database.Type.toLowerCase()) {
            default: {
                if (Utils.connection == null) break;
                this.getLogger().info("Closing SQLite database.");
                try {
                    Utils.closeSQLite();
                }
                catch (SQLException e) {
                    this.getLogger().severe("Failed to close SQLite database!");
                    this.getLogger().severe("Reason: " + e);
                }
                break;
            }
            case "mysql": {
                if (Utils.ds == null) break;
                this.getLogger().info("Closing MySQL database.");
                Utils.closeMySQL();
            }
        }
        this.getLogger().info("All tasks done. Thanks for use MiraiMC!");
    }
}

