/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.bukkit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import me.dreamvoid.miraimc.bukkit.BukkitPlugin;
import me.dreamvoid.miraimc.internal.Config;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitConfig {
    private final BukkitPlugin plugin;
    private static BukkitConfig Instance;

    public BukkitConfig(BukkitPlugin plugin) {
        Instance = this;
        this.plugin = plugin;
        Config.PluginDir = plugin.getDataFolder();
    }

    public void loadConfig() throws IOException, InvalidConfigurationException {
        this.plugin.saveDefaultConfig();
        YamlConfiguration y = new YamlConfiguration();
        y.options().pathSeparator('\\');
        y.load((Reader)new InputStreamReader(this.plugin.getResource("config.yml"), StandardCharsets.UTF_8));
        this.plugin.getConfig().setDefaults((Configuration)y);
        this.plugin.getConfig().options().copyDefaults(true);
        this.plugin.saveConfig();
        Config.General.AllowBStats = this.plugin.getConfig().getBoolean("general.allow-bStats", true);
        Config.General.CheckUpdate = this.plugin.getConfig().getBoolean("general.check-update", true);
        Config.General.DisableSafeWarningMessage = this.plugin.getConfig().getBoolean("general.disable-safe-warning-message", false);
        Config.General.MiraiWorkingDir = this.plugin.getConfig().getString("general.mirai-working-dir", "default");
        Config.General.AddProperties.MiraiNoDesktop = this.plugin.getConfig().getBoolean("general.add-properties.mirai.no-desktop", true);
        Config.General.AddProperties.MiraiSliderCaptchaSupported = this.plugin.getConfig().getBoolean("general.add-properties.mirai.slider.captcha.supported", true);
        Config.General.MiraiCoreVersion = this.plugin.getConfig().getString("general.mirai-core-version", "latest");
        Config.General.MavenRepoUrl = this.plugin.getConfig().getString("general.maven-repo-url", "https://repo1.maven.org/maven2");
        Config.General.EnableHttpApi = this.plugin.getConfig().getBoolean("general.enable-http-api", false);
        Config.General.LegacyEventSupport = this.plugin.getConfig().getBoolean("general.legacy-event-support", false);
        Config.Bot.DisableNetworkLogs = this.plugin.getConfig().getBoolean("bot.disable-network-logs", false);
        Config.Bot.DisableBotLogs = this.plugin.getConfig().getBoolean("bot.disable-bot-logs", false);
        Config.Bot.UseMinecraftLogger.BotLogs = this.plugin.getConfig().getBoolean("bot.use-minecraft-logger.bot-logs", true);
        Config.Bot.UseMinecraftLogger.NetworkLogs = this.plugin.getConfig().getBoolean("bot.use-minecraft-logger.network-logs", true);
        Config.Bot.LogEvents = this.plugin.getConfig().getBoolean("bot.log-events", true);
        Config.Bot.ContactCache.EnableFriendListCache = this.plugin.getConfig().getBoolean("bot.contact-cache.enable-friend-list-cache", false);
        Config.Bot.ContactCache.EnableGroupMemberListCache = this.plugin.getConfig().getBoolean("bot.contact-cache.enable-group-member-list-cache", false);
        Config.Bot.ContactCache.SaveIntervalMillis = this.plugin.getConfig().getLong("bot.contact-cache.save-interval-millis", 60000L);
        Config.Database.Type = this.plugin.getConfig().getString("database.type", "sqlite").toLowerCase();
        Config.Database.MySQL.Address = this.plugin.getConfig().getString("database.mysql.address", "localhost");
        Config.Database.MySQL.Username = this.plugin.getConfig().getString("database.mysql.username", "miraimc");
        Config.Database.MySQL.Password = this.plugin.getConfig().getString("database.mysql.password", "miraimc");
        Config.Database.MySQL.Database = this.plugin.getConfig().getString("database.mysql.database", "miraimc");
        Config.Database.MySQL.Poll.ConnectionTimeout = this.plugin.getConfig().getInt("database.mysql.pool.connectionTimeout", 30000);
        Config.Database.MySQL.Poll.IdleTimeout = this.plugin.getConfig().getInt("database.mysql.pool.connectionTimeout", 600000);
        Config.Database.MySQL.Poll.MaxLifetime = this.plugin.getConfig().getInt("database.mysql.pool.maxLifetime", 1800000);
        Config.Database.MySQL.Poll.MaximumPoolSize = this.plugin.getConfig().getInt("database.mysql.pool.maximumPoolSize", 15);
        Config.Database.MySQL.Poll.KeepaliveTime = this.plugin.getConfig().getInt("database.mysql.pool.keepaliveTime", 0);
        Config.Database.MySQL.Poll.MinimumIdle = this.plugin.getConfig().getInt("database.mysql.pool.minimumIdle", 0);
        Config.HttpApi.Url = this.plugin.getConfig().getString("http-api.url", "http://localhost:8080");
        Config.HttpApi.MessageFetch.Interval = this.plugin.getConfig().getInt("http-api.message-fetch.interval", 10);
        Config.HttpApi.MessageFetch.Count = this.plugin.getConfig().getInt("http-api.message-fetch.count", 10);
    }

    public static void reloadConfig() throws IOException, InvalidConfigurationException {
        Instance.loadConfig();
    }
}

