/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielthedev.npc;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftParrot;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NPC {
    private static AtomicInteger atomicInteger;
    private final String hideTeam;
    private final int entityID;
    private GameProfile profile;
    private final NPCMetaData metadata = new NPCMetaData();
    private final Location location;
    private Ping ping = Ping.FIVE_BARS;
    private Gamemode gamemode = Gamemode.CREATIVE;
    private String displayName;

    public NPC(UUID uuid, Location location, String displayName) {
        this.entityID = atomicInteger.incrementAndGet();
        this.profile = new GameProfile(uuid, displayName);
        this.location = location;
        this.displayName = displayName;
        this.hideTeam = "hide-" + Integer.toHexString(ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE));
    }

    public NPC(Location location, String displayName) {
        this(UUID.randomUUID(), location, displayName);
    }

    public void spawnNPC(Collection<Player> players) {
        players.forEach(this::spawnNPC);
    }

    public void spawnNPC(Player player) {
        this.addToTabList(player);
        this.sendPacket(player, (Packet<?>)this.getEntitySpawnPacket());
        this.updateMetadata(player);
    }

    public void destroyNPC(Collection<Player> players) {
        players.forEach(this::destroyNPC);
    }

    public void destroyNPC(Player player) {
        this.sendPacket(player, (Packet<?>)this.getPlayerInfoPacket(PlayerInfo.REMOVE_PLAYER));
        this.sendPacket(player, (Packet<?>)this.getEntityDestroyPacket());
    }

    public void reloadNPC(Collection<Player> players) {
        players.forEach(this::reloadNPC);
    }

    public void reloadNPC(Player player) {
        this.destroyNPC(player);
        this.spawnNPC(player);
    }

    public void teleportNPC(Collection<Player> players, Location location, boolean onGround) {
        players.forEach(p -> this.teleportNPC((Player)p, location, onGround));
    }

    public void teleportNPC(Player player, Location location, boolean onGround) {
        this.location.setX(location.getX());
        this.location.setY(location.getY());
        this.location.setZ(location.getZ());
        this.location.setPitch(location.getPitch());
        this.location.setYaw(location.getYaw());
        this.sendPacket(player, (Packet<?>)this.getEntityTeleportPacket(onGround));
        this.rotateHead(player, location.getPitch(), location.getYaw());
    }

    public void updateMetadata(Collection<Player> players) {
        players.forEach(this::updateMetadata);
    }

    public void updateMetadata(Player player) {
        this.sendPacket(player, (Packet<?>)this.getEntityMetadataPacket());
    }

    public void updateGameMode(Collection<Player> players) {
        players.forEach(this::updateGameMode);
    }

    public void updateGameMode(Player player) {
        this.sendPacket(player, (Packet<?>)this.getPlayerInfoPacket(PlayerInfo.UPDATE_GAME_MODE));
    }

    public void updatePing(Collection<Player> players) {
        players.forEach(this::updatePing);
    }

    public void updatePing(Player player) {
        this.sendPacket(player, (Packet<?>)this.getPlayerInfoPacket(PlayerInfo.UPDATE_LATENCY));
    }

    public void updateTabListName(Collection<Player> players) {
        players.forEach(this::updateTabListName);
    }

    public void updateTabListName(Player player) {
        this.sendPacket(player, (Packet<?>)this.getPlayerInfoPacket(PlayerInfo.UPDATE_DISPLAY_NAME));
    }

    public void removeFromTabList(Collection<Player> players) {
        players.forEach(this::removeFromTabList);
    }

    public void removeFromTabList(Player player) {
        this.sendPacket(player, (Packet<?>)this.getPlayerInfoPacket(PlayerInfo.REMOVE_PLAYER));
    }

    public void addToTabList(Collection<Player> players) {
        players.forEach(this::addToTabList);
    }

    public void addToTabList(Player player) {
        this.sendPacket(player, (Packet<?>)this.getPlayerInfoPacket(PlayerInfo.ADD_PLAYER));
    }

    public void playAnimation(Collection<Player> players, Animation animation) {
        players.forEach(p -> this.playAnimation((Player)p, animation));
    }

    public void playAnimation(Player player, Animation animation) {
        this.sendPacket(player, (Packet<?>)this.getEntityAnimationPacket(animation));
    }

    public void lookAtPlayer(Collection<Player> players, Player target) {
        players.forEach(p -> this.lookAtPlayer((Player)p, target));
    }

    public void lookAtPlayer(Player player, Player target) {
        this.lookAtPoint(player, target.getEyeLocation());
    }

    public void lookAtPoint(Collection<Player> players, Location location) {
        players.forEach(p -> this.lookAtPoint((Player)p, location));
    }

    public void lookAtPoint(Player player, Location location) {
        Location eyeLocation = this.getEyeLocation();
        float yaw = (float)Math.toDegrees(Math.atan2(location.getZ() - eyeLocation.getZ(), location.getX() - eyeLocation.getX())) - 90.0f;
        yaw = (float)((double)yaw + Math.ceil(-yaw / 360.0f) * 360.0);
        float deltaXZ = (float)Math.sqrt(Math.pow(eyeLocation.getX() - location.getX(), 2.0) + Math.pow(eyeLocation.getZ() - location.getZ(), 2.0));
        float pitch = (float)Math.toDegrees(Math.atan2(deltaXZ, location.getY() - eyeLocation.getY())) - 90.0f;
        pitch = (float)((double)pitch + Math.ceil(-pitch / 360.0f) * 360.0);
        this.rotateHead(player, pitch, yaw);
    }

    public void rotateHead(Collection<Player> players, float pitch, float yaw) {
        players.forEach(p -> this.rotateHead((Player)p, pitch, yaw));
    }

    public void rotateHead(Player player, float pitch, float yaw) {
        this.location.setPitch(pitch);
        this.location.setYaw(yaw);
        this.sendPacket(player, (Packet<?>)this.getEntityLookPacket());
        this.sendPacket(player, (Packet<?>)this.getEntityHeadRotatePacket());
    }

    public void setTabListName(String name) {
        this.displayName = name;
    }

    public void setEquipment(Collection<Player> players, ItemSlot slot, ItemStack itemStack) {
        players.forEach(p -> this.setEquipment((Player)p, slot, itemStack));
    }

    public void setEquipment(Player player, ItemSlot slot, ItemStack itemStack) {
        this.sendPacket(player, (Packet<?>)this.getEntityEquipmentPacket(slot.getSlot(), CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void setPassenger(Collection<Player> players, int ... entityIDs) {
        players.forEach(p -> this.setPassenger((Player)p, entityIDs));
    }

    public void setPassenger(Player player, int ... entityIDs) {
        this.sendPacket(player, (Packet<?>)this.getEntityAttachPacket(entityIDs));
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().b.sendPacket(packet);
    }

    public void setNameTagVisibility(Collection<Player> players, boolean show) {
        players.forEach(p -> this.setNameTagVisibility((Player)p, show));
    }

    public void setNameTagVisibility(Player player, boolean show) {
        ScoreboardTeam team = new ScoreboardTeam(new Scoreboard(), this.hideTeam);
        if (show) {
            PacketPlayOutScoreboardTeam leavePacket = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (String)this.profile.getName(), (PacketPlayOutScoreboardTeam.a)PacketPlayOutScoreboardTeam.a.b);
            this.sendPacket(player, (Packet<?>)leavePacket);
        } else {
            team.setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility.b);
            PacketPlayOutScoreboardTeam createPacket = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true);
            PacketPlayOutScoreboardTeam joinPacket = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (String)this.profile.getName(), (PacketPlayOutScoreboardTeam.a)PacketPlayOutScoreboardTeam.a.a);
            this.sendPacket(player, (Packet<?>)createPacket);
            this.sendPacket(player, (Packet<?>)joinPacket);
        }
    }

    private PacketPlayOutMount getEntityAttachPacket(int[] entityIDs) {
        return this.createDataSerializer(data -> {
            data.d(this.entityID);
            data.a(entityIDs);
            return new PacketPlayOutMount(data);
        });
    }

    private PacketPlayOutEntity.PacketPlayOutEntityLook getEntityLookPacket() {
        return new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entityID, (byte)(this.location.getYaw() * 256.0f / 360.0f), (byte)(this.location.getPitch() * 256.0f / 360.0f), true);
    }

    private PacketPlayOutEntityTeleport getEntityTeleportPacket(boolean onGround) {
        return this.createDataSerializer(data -> {
            data.d(this.entityID);
            data.writeDouble(this.location.getX());
            data.writeDouble(this.location.getY());
            data.writeDouble(this.location.getZ());
            data.writeByte((int)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
            data.writeByte((int)((byte)(this.location.getPitch() * 256.0f / 360.0f)));
            data.writeBoolean(onGround);
            return new PacketPlayOutEntityTeleport(data);
        });
    }

    private PacketPlayOutEntityHeadRotation getEntityHeadRotatePacket() {
        return this.createDataSerializer(data -> {
            data.d(this.entityID);
            data.writeByte((int)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
            return new PacketPlayOutEntityHeadRotation(data);
        });
    }

    private PacketPlayOutEntityEquipment getEntityEquipmentPacket(EnumItemSlot slot, net.minecraft.world.item.ItemStack itemStack) {
        return new PacketPlayOutEntityEquipment(this.entityID, Arrays.asList(new Pair((Object)slot, (Object)itemStack)));
    }

    private PacketPlayOutAnimation getEntityAnimationPacket(Animation animation) {
        return this.createDataSerializer(data -> {
            data.d(this.entityID);
            data.writeByte((int)((byte)animation.getType()));
            return new PacketPlayOutAnimation(data);
        });
    }

    private PacketPlayOutEntityDestroy getEntityDestroyPacket() {
        return new PacketPlayOutEntityDestroy(this.entityID);
    }

    private PacketPlayOutEntityMetadata getEntityMetadataPacket() {
        return this.createDataSerializer(data -> {
            data.d(this.entityID);
            DataWatcher.a(this.metadata.getList(), (PacketDataSerializer)data);
            return new PacketPlayOutEntityMetadata(data);
        });
    }

    private PacketPlayOutNamedEntitySpawn getEntitySpawnPacket() {
        return this.createDataSerializer(data -> {
            data.d(this.entityID);
            data.a(this.profile.getId());
            data.writeDouble(this.location.getX());
            data.writeDouble(this.location.getY());
            data.writeDouble(this.location.getZ());
            data.writeByte((int)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
            data.writeByte((int)((byte)(this.location.getPitch() * 256.0f / 360.0f)));
            return new PacketPlayOutNamedEntitySpawn(data);
        });
    }

    public PacketPlayOutPlayerInfo getPlayerInfoPacket(PlayerInfo playerInfo) {
        return this.createDataSerializer(data -> {
            PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = playerInfo.getPlayerInfo();
            PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData = new PacketPlayOutPlayerInfo.PlayerInfoData(this.profile, this.ping.getMilliseconds(), this.gamemode.getGamemode(), CraftChatMessage.fromString((String)this.displayName)[0]);
            List<PacketPlayOutPlayerInfo.PlayerInfoData> list = Arrays.asList(playerInfoData);
            data.a((Enum)playerInfo.getPlayerInfo());
            Method method = playerInfo.getPlayerInfo().getDeclaringClass().getDeclaredMethod("a", PacketDataSerializer.class, PacketPlayOutPlayerInfo.PlayerInfoData.class);
            method.setAccessible(true);
            data.a(list, (a2, b) -> this.unsafe(() -> method.invoke((Object)action, a2, b)));
            return new PacketPlayOutPlayerInfo(data);
        });
    }

    public int getEntityID() {
        return this.entityID;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public NPCMetaData getMetadata() {
        return this.metadata;
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getEyeLocation() {
        return this.location.clone().add(0.0, (double)(EntityTypes.bi.m().b * 0.85f), 0.0);
    }

    public Ping getPing() {
        return this.ping;
    }

    public Gamemode getGameMode() {
        return this.gamemode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setSkin(SkinTextures skinTextures) {
        this.profile.getProperties().put((Object)"textures", (Object)new Property("textures", skinTextures.getTexture(), skinTextures.getSignature()));
    }

    public void setASyncSkinByUsername(Plugin plugin, Collection<Player> players, String username) {
        this.setASyncSkinByUsername(plugin, players, username, null);
    }

    public void setASyncSkinByUsername(Plugin plugin, Player player, String username) {
        this.setASyncSkinByUsername(plugin, player, username, null);
    }

    public void setASyncSkinByUUID(Plugin plugin, Collection<Player> players, UUID uuid) {
        this.setASyncSkinByUUID(plugin, players, uuid, null);
    }

    public void setASyncSkinByUUID(Plugin plugin, Player player, UUID uuid) {
        this.setASyncSkinByUUID(plugin, player, uuid, null);
    }

    public void setASyncSkinByUsername(Plugin plugin, Player player, String username, BiConsumer<Boolean, NPC> callback) {
        SkinTextures.getByUsername(plugin, username, (success, skin) -> this.setASyncSkin((boolean)success, (SkinTextures)skin, player, callback));
    }

    public void setASyncSkinByUsername(Plugin plugin, Collection<Player> players, String username, BiConsumer<Boolean, NPC> callback) {
        SkinTextures.getByUsername(plugin, username, (success, skin) -> this.setASyncSkin((boolean)success, (SkinTextures)skin, players, callback));
    }

    public void setASyncSkinByUUID(Plugin plugin, Player player, UUID uuid, BiConsumer<Boolean, NPC> callback) {
        SkinTextures.getByUUID(plugin, uuid, (success, skin) -> this.setASyncSkin((boolean)success, (SkinTextures)skin, player, callback));
    }

    public void setASyncSkinByUUID(Plugin plugin, Collection<Player> players, UUID uuid, BiConsumer<Boolean, NPC> callback) {
        SkinTextures.getByUUID(plugin, uuid, (success, skin) -> this.setASyncSkin((boolean)success, (SkinTextures)skin, players, callback));
    }

    private void setASyncSkin(boolean success, SkinTextures skin, Collection<Player> players, BiConsumer<Boolean, NPC> callback) {
        if (success) {
            this.setSkin(skin);
            this.reloadNPC(players);
        }
        callback.accept(success, this);
    }

    private void setASyncSkin(boolean success, SkinTextures skin, Player player, BiConsumer<Boolean, NPC> callback) {
        this.setASyncSkin(success, skin, Arrays.asList(player), callback);
    }

    public void setPing(Ping ping) {
        this.ping = ping;
    }

    public void setGameMode(Gamemode gamemode) {
        this.gamemode = gamemode;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        GameProfile swapProfile = new GameProfile(this.profile.getId(), displayName);
        swapProfile.getProperties().putAll((Multimap)this.profile.getProperties());
        this.profile = swapProfile;
    }

    private void unsafe(UnsafeRunnable run) {
        try {
            run.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createDataSerializer(UnsafeFunction<PacketDataSerializer, T> callback) {
        PacketDataSerializer data = new PacketDataSerializer(Unpooled.buffer());
        T result = null;
        try {
            result = callback.apply(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            data.release();
        }
        return result;
    }

    static {
        try {
            Field field = Entity.class.getDeclaredField("b");
            field.setAccessible(true);
            atomicInteger = (AtomicInteger)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public class NPCMetaData {
        private final DataWatcher.Item<Byte> entityState = NPCMetaData.a(0, (byte)EntityState.createMask(EntityState.DEFAULT));
        private final DataWatcher.Item<Integer> airTicks = NPCMetaData.a(1, 300);
        private final DataWatcher.Item<Optional<IChatBaseComponent>> customName = NPCMetaData.a(2, Optional.empty(), DataWatcherRegistry.f);
        private final DataWatcher.Item<Boolean> customNameVisible = NPCMetaData.a(3, false);
        private final DataWatcher.Item<Boolean> silent = NPCMetaData.a(4, false);
        private final DataWatcher.Item<Boolean> gravity = NPCMetaData.a(5, false);
        private final DataWatcher.Item<EntityPose> pose = NPCMetaData.a(6, Pose.STANDING.getPose());
        private final DataWatcher.Item<Integer> frozenTicks = NPCMetaData.a(7, 0);
        private final DataWatcher.Item<Byte> handStatus = NPCMetaData.a(8, (byte)HandStatus.createMask(HandStatus.MAIN_HAND));
        private final DataWatcher.Item<Float> health = NPCMetaData.a(9, Float.valueOf(1.0f));
        private final DataWatcher.Item<Integer> potionEffectColor = NPCMetaData.a(10, 0);
        private final DataWatcher.Item<Boolean> isPotionEffectAmbient = NPCMetaData.a(11, false);
        private final DataWatcher.Item<Integer> arrowsInEntity = NPCMetaData.a(12, 0);
        private final DataWatcher.Item<Integer> absorptionHealth = NPCMetaData.a(13, 0);
        private final DataWatcher.Item<Optional<BlockPosition>> sleepingBedLocation = NPCMetaData.a(14, Optional.empty(), DataWatcherRegistry.m);
        private final DataWatcher.Item<Float> additionalHearts = NPCMetaData.a(15, Float.valueOf(0.0f));
        private final DataWatcher.Item<Integer> score = NPCMetaData.a(16, 0);
        private final DataWatcher.Item<Byte> skinStatus = NPCMetaData.a(17, (byte)SkinStatus.createMask(SkinStatus.ALL_ENABLED));
        private final DataWatcher.Item<Byte> hand = NPCMetaData.a(18, (byte)Hand.RIGHT.getType());
        private final DataWatcher.Item<NBTTagCompound> leftShoulder = NPCMetaData.a(19, new NBTTagCompound());
        private final DataWatcher.Item<NBTTagCompound> rightShoulder = NPCMetaData.a(20, new NBTTagCompound());
        private final List<DataWatcher.Item<?>> list = new ArrayList<DataWatcher.Item>(Arrays.asList(this.entityState, this.airTicks, this.customName, this.customNameVisible, this.silent, this.gravity, this.pose, this.frozenTicks, this.handStatus, this.health, this.potionEffectColor, this.isPotionEffectAmbient, this.arrowsInEntity, this.absorptionHealth, this.sleepingBedLocation, this.additionalHearts, this.score, this.skinStatus, this.hand, this.leftShoulder, this.rightShoulder));

        public EntityState[] getEntityState() {
            return EntityState.fromMask(((Byte)this.entityState.b()).byteValue());
        }

        public Integer getAirTicks() {
            return (Integer)this.airTicks.b();
        }

        public Optional<IChatBaseComponent> getCustomName() {
            return (Optional)this.customName.b();
        }

        public Boolean isCustomNameVisible() {
            return (Boolean)this.customNameVisible.b();
        }

        public Boolean isSilent() {
            return (Boolean)this.silent.b();
        }

        public Boolean hasGravity() {
            return (Boolean)this.gravity.b();
        }

        public Pose getPose() {
            return Pose.fromPose((EntityPose)this.pose.b());
        }

        public Integer getFrozenTicks() {
            return (Integer)this.frozenTicks.b();
        }

        public HandStatus[] getHandStatus() {
            return HandStatus.fromMask(((Byte)this.handStatus.b()).byteValue());
        }

        public Float getHealth() {
            return (Float)this.health.b();
        }

        public Integer getPotionEffectColor() {
            return (Integer)this.potionEffectColor.b();
        }

        public Boolean isPotionEffectAmbient() {
            return (Boolean)this.isPotionEffectAmbient.b();
        }

        public Integer getArrowsInEntity() {
            return (Integer)this.arrowsInEntity.b();
        }

        public Integer getAbsorptionHealth() {
            return (Integer)this.absorptionHealth.b();
        }

        public Optional<BlockPosition> getSleepingBedLocation() {
            return (Optional)this.sleepingBedLocation.b();
        }

        public Float getAdditionalHearts() {
            return (Float)this.additionalHearts.b();
        }

        public Integer getScore() {
            return (Integer)this.score.b();
        }

        public SkinStatus[] getSkinStatus() {
            return SkinStatus.fromMask(((Byte)this.skinStatus.b()).byteValue());
        }

        public Hand getHand() {
            return Hand.fromByte((Byte)this.hand.b());
        }

        public NBTTagCompound getLeftShoulder() {
            return (NBTTagCompound)this.leftShoulder.b();
        }

        public NBTTagCompound getRightShoulder() {
            return (NBTTagCompound)this.rightShoulder.b();
        }

        public List<DataWatcher.Item<?>> getList() {
            return this.list;
        }

        public void setEntityState(EntityState ... entityState) {
            this.entityState.a((Object)((byte)EntityState.createMask(entityState)));
        }

        public void setAirTicks(Integer airTicks) {
            this.airTicks.a((Object)airTicks);
        }

        public void setCustomName(String customName) {
            this.customName.a(Optional.ofNullable(IChatBaseComponent.a((String)customName)));
        }

        public void setCustomNameVisible(Boolean customNameVisible) {
            this.customNameVisible.a((Object)customNameVisible);
        }

        public void setSilent(Boolean silent) {
            this.silent.a((Object)silent);
        }

        public void setGravity(Boolean gravity) {
            this.gravity.a((Object)gravity);
        }

        public void setPose(Pose pose) {
            this.pose.a((Object)pose.getPose());
        }

        public void setFrozenTicks(Integer frozenTicks) {
            this.frozenTicks.a((Object)frozenTicks);
        }

        public void setShaking() {
            this.setFrozenTicks(140);
        }

        public void setHandStatus(HandStatus handStatus) {
            this.handStatus.a((Object)((byte)HandStatus.createMask(handStatus)));
        }

        public void setHealth(Float health) {
            this.health.a((Object)health);
        }

        public void setPotionEffectColor(Integer potionEffectColor) {
            this.potionEffectColor.a((Object)potionEffectColor);
        }

        public void setIsPotionEffectAmbient(Boolean isPotionEffectAmbient) {
            this.isPotionEffectAmbient.a((Object)isPotionEffectAmbient);
        }

        public void setArrowsInEntity(Integer arrowsInEntity) {
            this.arrowsInEntity.a((Object)arrowsInEntity);
        }

        public void setAbsorptionHealth(Integer absorptionHealth) {
            this.absorptionHealth.a((Object)absorptionHealth);
        }

        public void setSleepingBedLocation(BlockPosition sleepingBedLocation) {
            this.sleepingBedLocation.a(Optional.ofNullable(sleepingBedLocation));
        }

        public void setAdditionalHearts(Float additionalHearts) {
            this.additionalHearts.a((Object)additionalHearts);
        }

        public void setScore(Integer score) {
            this.score.a((Object)score);
        }

        public void setSkinStatus(SkinStatus ... skinStatus) {
            this.skinStatus.a((Object)((byte)SkinStatus.createMask(skinStatus)));
        }

        public void setHand(Hand hand) {
            this.hand.a((Object)((byte)hand.getType()));
        }

        public NBTTagCompound createParrot(Consumer<Parrot> callback, World world) {
            EntityParrot entityParrot = new EntityParrot(EntityTypes.al, (net.minecraft.world.level.World)((CraftWorld)world).getHandle());
            CraftParrot parrot = new CraftParrot((CraftServer)Bukkit.getServer(), entityParrot);
            callback.accept((Parrot)parrot);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            entityParrot.d(nbtTagCompound);
            return nbtTagCompound;
        }

        public void setParrotLeftShoulder(Consumer<Parrot> callback, World world) {
            this.setLeftShoulder(this.createParrot(callback, world));
        }

        public void setParrotRightShoulder(Consumer<Parrot> callback, World world) {
            this.setRightShoulder(this.createParrot(callback, world));
        }

        public void setLeftShoulder(NBTTagCompound leftShoulder) {
            this.leftShoulder.a((Object)leftShoulder);
        }

        public void setRightShoulder(NBTTagCompound rightShoulder) {
            this.rightShoulder.a((Object)rightShoulder);
        }

        private static <T> DataWatcher.Item<T> a(int index, T value) {
            DataWatcherSerializer serializer = null;
            if (value instanceof Byte) {
                serializer = DataWatcherRegistry.a;
            } else if (value instanceof Float) {
                serializer = DataWatcherRegistry.c;
            } else if (value instanceof Integer) {
                serializer = DataWatcherRegistry.b;
            } else if (value instanceof String) {
                serializer = DataWatcherRegistry.d;
            } else if (value instanceof Boolean) {
                serializer = DataWatcherRegistry.i;
            } else if (value instanceof NBTTagCompound) {
                serializer = DataWatcherRegistry.p;
            } else if (value instanceof BlockPosition) {
                serializer = DataWatcherRegistry.m;
            } else if (value instanceof IChatBaseComponent) {
                serializer = DataWatcherRegistry.e;
            } else if (value instanceof EntityPose) {
                serializer = DataWatcherRegistry.s;
            }
            return NPCMetaData.a(index, value, serializer);
        }

        private static <T> DataWatcher.Item<T> a(int index, T value, DataWatcherSerializer<T> serializer) {
            return new DataWatcher.Item(new DataWatcherObject(index, serializer), value);
        }
    }

    public static enum Ping {
        NO_CONNECTION(-1),
        ONE_BAR(1000),
        TWO_BARS(999),
        THREE_BARS(599),
        FOUR_BARS(299),
        FIVE_BARS(149);

        private final int milliseconds;

        private Ping(int milliseconds) {
            this.milliseconds = milliseconds;
        }

        public int getMilliseconds() {
            return this.milliseconds;
        }
    }

    public static enum Gamemode {
        SURVIVAL(EnumGamemode.a),
        CREATIVE(EnumGamemode.b),
        ADVENTURE(EnumGamemode.c),
        SPECTATOR(EnumGamemode.d);

        private final EnumGamemode gamemode;

        private Gamemode(EnumGamemode gamemode) {
            this.gamemode = gamemode;
        }

        public EnumGamemode getGamemode() {
            return this.gamemode;
        }
    }

    public static enum PlayerInfo {
        ADD_PLAYER(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a),
        UPDATE_GAME_MODE(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.b),
        UPDATE_LATENCY(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c),
        UPDATE_DISPLAY_NAME(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d),
        REMOVE_PLAYER(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e);

        private final PacketPlayOutPlayerInfo.EnumPlayerInfoAction playerInfo;

        private PlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction a2) {
            this.playerInfo = a2;
        }

        public PacketPlayOutPlayerInfo.EnumPlayerInfoAction getPlayerInfo() {
            return this.playerInfo;
        }
    }

    public static enum Animation {
        SWING_MAIN_HAND(0),
        TAKE_DAMAGE(1),
        LEAVE_BED(2),
        SWING_OFFHAND(3),
        CRITICAL_EFFECT(4),
        MAGIC_CRITICAL_EFFECT(5);

        private final int type;

        private Animation(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum ItemSlot {
        MAIN_HAND(EnumItemSlot.a),
        OFF_HAND(EnumItemSlot.b),
        BOOTS(EnumItemSlot.c),
        LEGGINGS(EnumItemSlot.d),
        CHESTPLATE(EnumItemSlot.e),
        HELMET(EnumItemSlot.f);

        private final EnumItemSlot slot;

        private ItemSlot(EnumItemSlot slot) {
            this.slot = slot;
        }

        public EnumItemSlot getSlot() {
            return this.slot;
        }
    }

    @FunctionalInterface
    private static interface UnsafeFunction<K, T> {
        public T apply(K var1) throws Exception;
    }

    public static class SkinTextures {
        private static final String TEXTURE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
        private static final String UUID_URL = "https://api.mojang.com/profiles/minecraft";
        private final String texture;
        private final String signature;

        public SkinTextures(String textures, String signature) {
            this.texture = textures;
            this.signature = signature;
        }

        public String getTexture() {
            return this.texture;
        }

        public String getSignature() {
            return this.signature;
        }

        public static void getByUsername(final Plugin plugin, final String username, final BiConsumer<Boolean, SkinTextures> callback) {
            new BukkitRunnable(){

                public void run() {
                    JSONArray array = new JSONArray();
                    array.add((Object)username);
                    UUID result = null;
                    try {
                        JSONArray uuidArray;
                        HttpRequest request = HttpRequest.newBuilder(new URI(SkinTextures.UUID_URL)).setHeader("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(array.toString())).timeout(Duration.ofSeconds(5L)).build();
                        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                        if (response.statusCode() == 200 && (uuidArray = (JSONArray)new JSONParser().parse(response.body())).size() > 0) {
                            String uuidStr = (String)((JSONObject)uuidArray.get(0)).get((Object)"id");
                            result = UUID.fromString(uuidStr.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                        }
                    }
                    catch (IOException | InterruptedException | URISyntaxException | ParseException e) {
                        e.printStackTrace();
                    }
                    if (result == null) {
                        new BukkitRunnable(){

                            public void run() {
                                callback.accept(false, null);
                            }
                        }.runTask(plugin);
                    } else {
                        SkinTextures.getByUUID(plugin, result, callback);
                    }
                }
            }.runTaskAsynchronously(plugin);
        }

        public static void getByUUID(final Plugin plugin, final UUID uuid, final BiConsumer<Boolean, SkinTextures> callback) {
            new BukkitRunnable(){

                public void run() {
                    SkinTextures result = null;
                    try {
                        HttpRequest request = HttpRequest.newBuilder(new URI(String.format(SkinTextures.TEXTURE_URL, uuid.toString().replace("-", "")))).timeout(Duration.ofSeconds(5L)).GET().build();
                        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                        if (response.statusCode() == 200) {
                            JSONArray properties = (JSONArray)((JSONObject)new JSONParser().parse(response.body())).get((Object)"properties");
                            for (int t = 0; t < properties.size(); ++t) {
                                JSONObject obj = (JSONObject)properties.get(t);
                                if (!obj.containsKey((Object)"name") || !obj.get((Object)"name").equals("textures")) continue;
                                result = new SkinTextures((String)obj.get((Object)"value"), (String)obj.get((Object)"signature"));
                            }
                        }
                    }
                    catch (IOException | InterruptedException | URISyntaxException | ParseException e) {
                        e.printStackTrace();
                    }
                    final SkinTextures skinTextures = result;
                    new BukkitRunnable(){

                        public void run() {
                            if (skinTextures == null) {
                                callback.accept(false, null);
                            } else {
                                callback.accept(true, skinTextures);
                            }
                        }
                    }.runTask(plugin);
                }
            }.runTaskAsynchronously(plugin);
        }

        public static CompletableFuture<SkinTextures> getByUsername(String username) {
            return CompletableFuture.supplyAsync(() -> {
                JSONArray array = new JSONArray();
                array.add((Object)username);
                UUID result = null;
                try {
                    JSONArray uuidArray;
                    HttpRequest request = HttpRequest.newBuilder(new URI(UUID_URL)).setHeader("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(array.toString())).timeout(Duration.ofSeconds(5L)).build();
                    HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() == 200 && (uuidArray = (JSONArray)new JSONParser().parse(response.body())).size() > 0) {
                        String uuidStr = (String)((JSONObject)uuidArray.get(0)).get((Object)"id");
                        result = UUID.fromString(uuidStr.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                    }
                }
                catch (IOException | InterruptedException | URISyntaxException | ParseException e) {
                    e.printStackTrace();
                }
                if (result == null) {
                    throw new IllegalArgumentException("SkinTextures not found by username");
                }
                return SkinTextures.getByUUID(result).join();
            });
        }

        public static CompletableFuture<SkinTextures> getByUUID(UUID uuid) {
            return CompletableFuture.supplyAsync(() -> {
                SkinTextures result = null;
                try {
                    HttpRequest request = HttpRequest.newBuilder(new URI(String.format(TEXTURE_URL, uuid.toString().replace("-", "")))).timeout(Duration.ofSeconds(5L)).GET().build();
                    HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() == 200) {
                        JSONArray properties = (JSONArray)((JSONObject)new JSONParser().parse(response.body())).get((Object)"properties");
                        for (int t = 0; t < properties.size(); ++t) {
                            JSONObject obj = (JSONObject)properties.get(t);
                            if (!obj.containsKey((Object)"name") || !obj.get((Object)"name").equals("textures")) continue;
                            result = new SkinTextures((String)obj.get((Object)"value"), (String)obj.get((Object)"signature"));
                        }
                    }
                }
                catch (IOException | InterruptedException | URISyntaxException | ParseException e) {
                    e.printStackTrace();
                }
                if (result == null) {
                    throw new IllegalArgumentException("SkinTextures not found by uuid");
                }
                return result;
            });
        }
    }

    @FunctionalInterface
    private static interface UnsafeRunnable {
        public void run() throws Exception;
    }

    public static enum EntityState {
        DEFAULT(0),
        ON_FIRE(1),
        CROUCHING(2),
        UNUSED(4),
        SPRINTING(8),
        SWIMMING(16),
        INVISIBLE(32),
        GLOWING(64),
        FLYING(128),
        ALL(255);

        private final int mask;

        private EntityState(int mask) {
            this.mask = mask;
        }

        public int getMask() {
            return this.mask;
        }

        public static int createMask(EntityState ... entityStates) {
            int mask = 0;
            for (EntityState entityState : entityStates) {
                mask |= entityState.mask;
            }
            return mask;
        }

        public static EntityState[] fromMask(int mask) {
            ArrayList<EntityState> list = new ArrayList<EntityState>();
            for (EntityState entityState : EntityState.values()) {
                if ((entityState.mask & mask) != entityState.mask) continue;
                list.add(entityState);
            }
            return list.toArray(new EntityState[list.size()]);
        }
    }

    public static enum HandStatus {
        MAIN_HAND(0),
        HAND_ACTIVE(1),
        OFF_HAND(2),
        RIPTIDE_SPIN_ATTACK(4),
        ALL(7);

        private final int mask;

        private HandStatus(int mask) {
            this.mask = mask;
        }

        public int getMask() {
            return this.mask;
        }

        public static int createMask(HandStatus ... handStatuses) {
            int mask = 0;
            for (HandStatus handStatus : handStatuses) {
                mask |= handStatus.mask;
            }
            return mask;
        }

        public static HandStatus[] fromMask(int mask) {
            ArrayList<HandStatus> list = new ArrayList<HandStatus>();
            for (HandStatus handStatus : HandStatus.values()) {
                if ((handStatus.mask & mask) != handStatus.mask) continue;
                list.add(handStatus);
            }
            return list.toArray(new HandStatus[list.size()]);
        }
    }

    public static enum SkinStatus {
        CAPE_ENABLED(1),
        JACKET_ENABLED(2),
        LEFT_SLEEVE_ENABLED(4),
        RIGHT_SLEEVE_ENABLED(8),
        LEFT_PANTS_LEG_ENABLED(16),
        RIGHT_PANTS_LEG_ENABLED(32),
        HAT_ENABLED(64),
        UNUSED(128),
        ALL_ENABLED(255);

        private final int mask;

        private SkinStatus(int mask) {
            this.mask = mask;
        }

        public int getMask() {
            return this.mask;
        }

        public static int createMask(SkinStatus ... skinStatuses) {
            int mask = 0;
            for (SkinStatus handStatus : skinStatuses) {
                mask |= handStatus.mask;
            }
            return mask;
        }

        public static SkinStatus[] fromMask(int mask) {
            ArrayList<SkinStatus> list = new ArrayList<SkinStatus>();
            for (SkinStatus skinStatus : SkinStatus.values()) {
                if ((skinStatus.mask & mask) != skinStatus.mask) continue;
                list.add(skinStatus);
            }
            return list.toArray(new SkinStatus[list.size()]);
        }
    }

    public static enum Pose {
        STANDING(EntityPose.a),
        FALL_FLYING(EntityPose.b),
        SLEEPING(EntityPose.c),
        SWIMMING(EntityPose.d),
        SPIN_ATTACK(EntityPose.e),
        CROUCHING(EntityPose.f),
        LONG_JUMPING(EntityPose.g),
        DYING(EntityPose.h);

        private final EntityPose pose;

        private Pose(EntityPose pose) {
            this.pose = pose;
        }

        public EntityPose getPose() {
            return this.pose;
        }

        public static Pose fromPose(EntityPose entityPose) {
            for (Pose pose : Pose.values()) {
                if (entityPose != pose.pose) continue;
                return pose;
            }
            return null;
        }
    }

    public static enum Hand {
        LEFT(0),
        RIGHT(1);

        private final int type;

        private Hand(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static Hand fromByte(byte type) {
            for (Hand hand : Hand.values()) {
                if (type != hand.type) continue;
                return hand;
            }
            return null;
        }
    }
}

