/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.suppliers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AuthorizationException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Throwables2;
import java.util.concurrent.atomic.AtomicReference;

public class SetAndThrowAuthorizationExceptionSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private final AtomicReference<AuthorizationException> authException;

    public SetAndThrowAuthorizationExceptionSupplier(Supplier<T> delegate, AtomicReference<AuthorizationException> authException) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.authException = Preconditions.checkNotNull(authException, "authException");
    }

    @Override
    public T get() {
        if (this.authException.get() != null) {
            throw this.authException.get();
        }
        try {
            return this.delegate.get();
        }
        catch (AuthorizationException e) {
            this.authException.set(e);
            throw e;
        }
        catch (Exception e) {
            AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
            if (aex != null) {
                this.authException.set(aex);
                throw aex;
            }
            throw Throwables.propagate(e);
        }
    }

    public String toString() {
        return "RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(" + this.delegate + ")";
    }
}

