/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.suppliers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.MoreObjects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.cache.CacheBuilder;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.cache.CacheLoader;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.cache.LoadingCache;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ForwardingObject;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AuthorizationException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.suppliers.ValueLoadedCallback;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Throwables2;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T>
extends ForwardingObject
implements Supplier<T> {
    private final Supplier<T> delegate;
    private final long duration;
    private final TimeUnit unit;
    private final LoadingCache<String, Optional<T>> cache;

    public static <T> MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T> create(AtomicReference<AuthorizationException> authException, Supplier<T> delegate, long duration, TimeUnit unit) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T>(authException, delegate, duration, unit, new ValueLoadedCallback.NoOpCallback());
    }

    public static <T> MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T> create(AtomicReference<AuthorizationException> authException, Supplier<T> delegate, long duration, TimeUnit unit, ValueLoadedCallback<T> valueLoadedCallback) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<T>(authException, delegate, duration, unit, valueLoadedCallback);
    }

    MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(AtomicReference<AuthorizationException> authException, Supplier<T> delegate, long duration, TimeUnit unit, ValueLoadedCallback<T> valueLoadedCallback) {
        this.delegate = delegate;
        this.duration = duration;
        this.unit = unit;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(duration, unit).build(new SetAndThrowAuthorizationExceptionSupplierBackedLoader<T>(delegate, authException, valueLoadedCallback));
    }

    @Override
    protected Supplier<T> delegate() {
        return this.delegate;
    }

    @Override
    public T get() {
        try {
            return this.cache.get("FOO").orNull();
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.delegate).add("duration", this.duration).add("unit", (Object)this.unit).toString();
    }

    public static class ValueLoadedEvent<V> {
        private final Object eventKey;
        private final Optional<V> value;

        public ValueLoadedEvent(Object eventKey, Optional<V> value) {
            this.eventKey = Preconditions.checkNotNull(eventKey, "eventKey");
            this.value = Preconditions.checkNotNull(value, "value");
        }

        public Object getEventKey() {
            return this.eventKey;
        }

        public Optional<V> getValue() {
            return this.value;
        }
    }

    static class SetAndThrowAuthorizationExceptionSupplierBackedLoader<V>
    extends CacheLoader<String, Optional<V>> {
        private final Supplier<V> delegate;
        private final AtomicReference<AuthorizationException> authException;
        private final ValueLoadedCallback<V> valueLoadedCallback;

        public SetAndThrowAuthorizationExceptionSupplierBackedLoader(Supplier<V> delegate, AtomicReference<AuthorizationException> authException, ValueLoadedCallback<V> valueLoadedCallback) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.authException = Preconditions.checkNotNull(authException, "authException");
            this.valueLoadedCallback = Preconditions.checkNotNull(valueLoadedCallback, "valueLoadedCallback");
        }

        @Override
        public Optional<V> load(String key) {
            if (this.authException.get() != null) {
                throw this.authException.get();
            }
            try {
                Optional<V> value = Optional.fromNullable(this.delegate.get());
                this.valueLoadedCallback.valueLoaded(value);
                return value;
            }
            catch (Exception e) {
                AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
                if (aex != null) {
                    this.authException.set(aex);
                    throw aex;
                }
                throw Throwables.propagate(e);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate).toString();
        }
    }
}

