/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.internal;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Functions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.Invokable;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.TypeToken;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Injector;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Key;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.util.Types;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.functions.IdentityFunction;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.functions.OnlyElementOrNull;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ParseFirstJsonValueNamed;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ParseJson;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ParseSax;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ParseURIFromListOrLocationHeaderIf20x;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ParseXMLWithJAXB;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ReleasePayloadAndReturn;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ReturnInputStream;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ReturnStringIf2xx;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.ReturnTrueIf2xx;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions.UnwrapOnlyJsonValue;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.internal.GsonWrapper;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.Invocation;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.InvocationContext;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.JAXBResponseParser;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.OnlyElement;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.ResponseParser;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.SelectJson;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Transform;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Unwrap;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.XMLResponseParser;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.internal.GeneratedHttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.internal.GetAcceptHeaders;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Set;
import javax.lang.model.type.NullType;

public class TransformerForRequest
implements Function<HttpRequest, Function<HttpResponse, ?>> {
    private final ParseSax.Factory parserFactory;
    private final Injector injector;
    private final GetAcceptHeaders getAcceptHeaders;

    @Inject
    TransformerForRequest(Injector injector, ParseSax.Factory parserFactory, GetAcceptHeaders getAcceptHeaders) {
        this.injector = injector;
        this.parserFactory = parserFactory;
        this.getAcceptHeaders = getAcceptHeaders;
    }

    @Override
    public Function<HttpResponse, ?> apply(HttpRequest in) {
        Function<HttpResponse, Object> transformer;
        GeneratedHttpRequest request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(in);
        Class<? extends ParseSax.HandlerWithResult<?>> handler = TransformerForRequest.getSaxResponseParserClassOrNull(request.getInvocation().getInvokable());
        if (handler != null) {
            ParseSax.HandlerWithResult<?> h2 = this.injector.getInstance(handler);
            transformer = this.parserFactory.create(h2);
        } else {
            transformer = this.getTransformerForMethod(request.getInvocation(), this.injector);
        }
        if (transformer instanceof InvocationContext) {
            ((InvocationContext)InvocationContext.class.cast(transformer)).setContext(request);
        }
        if (request.getInvocation().getInvokable().isAnnotationPresent(Transform.class)) {
            Function<?, ?> wrappingTransformer = this.injector.getInstance(request.getInvocation().getInvokable().getAnnotation(Transform.class).value());
            if (wrappingTransformer instanceof InvocationContext) {
                ((InvocationContext)((Object)wrappingTransformer)).setContext(request);
            }
            transformer = Functions.compose((Function)Function.class.cast(wrappingTransformer), transformer);
        }
        return transformer;
    }

    @VisibleForTesting
    Key<? extends Function<HttpResponse, ?>> getParserOrThrowException(Invocation invocation) {
        Invokable<?, ?> invoked = invocation.getInvokable();
        Set<String> acceptHeaders = this.getAcceptHeaders.apply(invocation);
        ResponseParser annotation = invoked.getAnnotation(ResponseParser.class);
        Class<?> rawReturnType = invoked.getReturnType().getRawType();
        if (annotation == null) {
            if (rawReturnType.equals(Void.TYPE)) {
                return Key.get(ReleasePayloadAndReturn.class);
            }
            if (rawReturnType.equals(Boolean.TYPE) || rawReturnType.equals(Boolean.class)) {
                return Key.get(ReturnTrueIf2xx.class);
            }
            if (rawReturnType.equals(InputStream.class)) {
                return Key.get(ReturnInputStream.class);
            }
            if (rawReturnType.equals(HttpResponse.class)) {
                return Key.get((Class)Class.class.cast(IdentityFunction.class));
            }
            if (acceptHeaders.contains("application/json")) {
                return TransformerForRequest.getJsonParserKeyForMethod(invoked);
            }
            if (acceptHeaders.contains("application/xml") || invoked.isAnnotationPresent(JAXBResponseParser.class)) {
                return TransformerForRequest.getJAXBParserKeyForMethod(invoked);
            }
            if (rawReturnType.equals(String.class)) {
                return Key.get(ReturnStringIf2xx.class);
            }
            if (rawReturnType.equals(URI.class)) {
                return Key.get(ParseURIFromListOrLocationHeaderIf20x.class);
            }
            throw new IllegalStateException("You must specify a ResponseParser annotation on: " + invoked.toString());
        }
        return Key.get(annotation.value());
    }

    private static Key<? extends Function<HttpResponse, ?>> getJAXBParserKeyForMethod(Invokable<?, ?> invoked) {
        Optional<Type> configuredReturnVal = Optional.absent();
        if (invoked.isAnnotationPresent(JAXBResponseParser.class)) {
            Class<?> configuredClass = invoked.getAnnotation(JAXBResponseParser.class).value();
            configuredReturnVal = configuredClass.equals(NullType.class) ? Optional.absent() : Optional.of(configuredClass);
        }
        Type returnVal = configuredReturnVal.or(TransformerForRequest.getReturnTypeFor(invoked.getReturnType()));
        ParameterizedType parserType = Types.newParameterizedType(ParseXMLWithJAXB.class, new Type[]{returnVal});
        return Key.get(parserType);
    }

    private static Key<? extends Function<HttpResponse, ?>> getJsonParserKeyForMethod(Invokable<?, ?> invoked) {
        ParameterizedType parserType;
        if (invoked.isAnnotationPresent(Unwrap.class)) {
            parserType = Types.newParameterizedType(UnwrapOnlyJsonValue.class, new Type[]{TransformerForRequest.getReturnTypeFor(invoked.getReturnType())});
        } else if (invoked.isAnnotationPresent(Transform.class)) {
            TypeToken<Function<?, ?>> fn = TypeToken.of(invoked.getAnnotation(Transform.class).value());
            Type fnInput = ((ParameterizedType)fn.getSupertype(Function.class).getType()).getActualTypeArguments()[0];
            parserType = Types.newParameterizedType(ParseJson.class, new Type[]{fnInput});
        } else {
            parserType = Types.newParameterizedType(ParseJson.class, new Type[]{TransformerForRequest.getReturnTypeFor(invoked.getReturnType())});
        }
        return Key.get(parserType);
    }

    static Type getReturnTypeFor(TypeToken<?> typeToken) {
        Class<?> returnVal = typeToken.getType();
        if (typeToken.getRawType().getTypeParameters().length == 0) {
            returnVal = typeToken.getRawType();
        }
        return returnVal;
    }

    @VisibleForTesting
    public Function<HttpResponse, ?> getTransformerForMethod(Invocation invocation, Injector injector) {
        Function<HttpResponse, Object> transformer;
        Invokable<?, ?> invoked = invocation.getInvokable();
        if (invoked.isAnnotationPresent(SelectJson.class)) {
            Type returnVal = TransformerForRequest.getReturnTypeFor(invoked.getReturnType());
            if (invoked.isAnnotationPresent(OnlyElement.class)) {
                returnVal = Types.newParameterizedType(Set.class, new Type[]{returnVal});
            }
            transformer = new ParseFirstJsonValueNamed(injector.getInstance(GsonWrapper.class), TypeLiteral.get(returnVal), invoked.getAnnotation(SelectJson.class).value());
            if (invoked.isAnnotationPresent(OnlyElement.class)) {
                transformer = Functions.compose(new OnlyElementOrNull(), transformer);
            }
        } else {
            transformer = injector.getInstance(this.getParserOrThrowException(invocation));
        }
        return transformer;
    }

    static Class<? extends ParseSax.HandlerWithResult<?>> getSaxResponseParserClassOrNull(Invokable<?, ?> invoked) {
        XMLResponseParser annotation = invoked.getAnnotation(XMLResponseParser.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }
}

