/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.VisibleForTesting;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.cache.CacheBuilder;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.cache.CacheLoader;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.cache.LoadingCache;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.InvocationSuccess;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.ApiVersion;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.SinceApiVersion;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.functions.ImplicitOptionalConverter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Optionals2;

@Singleton
@Beta
public class PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion
implements ImplicitOptionalConverter {
    private final LoadingCache<InvocationSuccess, Optional<Object>> lookupCache;

    @Inject
    protected PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion(@ApiVersion String apiVersion) {
        this.lookupCache = CacheBuilder.newBuilder().build(new Loader(apiVersion));
    }

    @Override
    public Optional<Object> apply(InvocationSuccess input) {
        return this.lookupCache.getUnchecked(input);
    }

    @VisibleForTesting
    static final class Loader
    extends CacheLoader<InvocationSuccess, Optional<Object>> {
        private final String apiVersion;

        @Inject
        Loader(@ApiVersion String apiVersion) {
            this.apiVersion = Preconditions.checkNotNull(apiVersion, "apiVersion");
        }

        @Override
        public Optional<Object> load(InvocationSuccess input) {
            Class<?> target = Optionals2.unwrapIfOptional(input.getInvocation().getInvokable().getReturnType());
            Optional<SinceApiVersion> sinceApiVersion = Optional.fromNullable(target.getAnnotation(SinceApiVersion.class));
            if (sinceApiVersion.isPresent()) {
                String since = sinceApiVersion.get().value();
                if (since.compareTo(this.apiVersion) <= 0) {
                    return input.getResult();
                }
                return Optional.absent();
            }
            return input.getResult();
        }
    }
}

