/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.binders;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.Invokable;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.UriTemplates;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.MapBinder;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.annotations.Payload;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.internal.GeneratedHttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.util.Map;

@Singleton
public class BindMapToStringPayload
implements MapBinder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkNotNull(postParams, "postParams");
        GeneratedHttpRequest r = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(Preconditions.checkNotNull(request, "request"));
        Invokable<?, ?> invoked = r.getInvocation().getInvokable();
        Preconditions.checkArgument(invoked.isAnnotationPresent(Payload.class), "method %s must have @Payload annotation to use this binder", invoked);
        String payload = invoked.getAnnotation(Payload.class).value();
        if (!postParams.isEmpty()) {
            payload = Strings2.urlDecode(UriTemplates.expand(payload, postParams));
        }
        return (R)((HttpRequest.Builder)request.toBuilder().payload(payload)).build();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        throw new IllegalArgumentException("this is a map binder");
    }
}

