/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.fromconfig;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Splitter;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Suppliers;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.config.ValueOfConfigurationKeyOrNull;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Region;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Zone;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.util.Map;
import java.util.Set;

@Singleton
public class RegionIdToZoneIdsFromConfiguration
implements RegionIdToZoneIdsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ValueOfConfigurationKeyOrNull config;
    private final String provider;
    private final Supplier<Set<String>> regionsSupplier;

    @Inject
    protected RegionIdToZoneIdsFromConfiguration(ValueOfConfigurationKeyOrNull config, @Provider String provider, @Region Supplier<Set<String>> regionsSupplier) {
        this.config = config;
        this.provider = provider;
        this.regionsSupplier = regionsSupplier;
    }

    @Override
    @Singleton
    @Zone
    public Map<String, Supplier<Set<String>>> get() {
        Set<String> regions = this.regionsSupplier.get();
        if (regions.isEmpty()) {
            this.logger.debug("no regions configured for provider %s", this.provider);
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, Supplier<ImmutableSet<String>>> regionToZones = ImmutableMap.builder();
        for (String region : regions) {
            String configKey = "jclouds.region." + region + ".zones";
            String zones = this.config.apply(configKey);
            if (zones == null) {
                this.logger.debug("config key %s not present", configKey);
                continue;
            }
            regionToZones.put(region, Suppliers.ofInstance(ImmutableSet.copyOf(Splitter.on(',').split(zones))));
        }
        return regionToZones.build();
    }
}

