/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.predicates.fromconfig;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.predicates.ZoneIdFilter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.fromconfig.ZoneIdsFromConfiguration;

@Singleton
public class AnyOrConfiguredZoneId
implements ZoneIdFilter {
    private ZoneIdsFromConfiguration idsInConfigSupplier;

    @Inject
    protected AnyOrConfiguredZoneId(ZoneIdsFromConfiguration idsInConfigSupplier) {
        this.idsInConfigSupplier = Preconditions.checkNotNull(idsInConfigSupplier, "idsInConfigSupplier");
    }

    @Override
    public boolean apply(String input) {
        Object idsInConfig = this.idsInConfigSupplier.get();
        if (idsInConfig.isEmpty()) {
            return true;
        }
        return idsInConfig.contains(input);
    }

    public String toString() {
        return "anyOrConfiguredZoneId(" + this.idsInConfigSupplier + ")";
    }
}

