/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.javax.annotation.Nullable;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Region;
import java.net.URI;
import java.util.Map;

public final class RegionToEndpointOrProviderIfNull
implements Function<Object, URI> {
    private final Supplier<URI> defaultUri;
    private final String defaultProvider;
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    RegionToEndpointOrProviderIfNull(@Provider String defaultProvider, @Provider Supplier<URI> defaultUri, @Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.defaultProvider = defaultProvider;
        this.defaultUri = defaultUri;
        this.regionToEndpointSupplier = regionToEndpointSupplier;
    }

    @Override
    public URI apply(@Nullable Object from) {
        if (from == null) {
            return this.defaultUri.get();
        }
        Map<String, Supplier<URI>> regionToEndpoint = this.regionToEndpointSupplier.get();
        if (from.equals(this.defaultProvider)) {
            if (regionToEndpoint.containsKey(from)) {
                return regionToEndpoint.get(from).get();
            }
            return this.defaultUri.get();
        }
        Preconditions.checkArgument(regionToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, regionToEndpoint);
        return regionToEndpoint.get(from).get();
    }
}

