/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.lifecycle.config;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.Invokable;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.ExecutionList;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.MoreExecutors;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.AbstractModule;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.matcher.Matchers;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.InjectionListener;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.TypeEncounter;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.TypeListener;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.PostConstruct;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.PreDestroy;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.lifecycle.Closer;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.Reflection2;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;

public class LifeCycleModule
extends AbstractModule {
    private static final Predicate<Invokable<?, ?>> isPreDestroy = new Predicate<Invokable<?, ?>>(){

        @Override
        public boolean apply(Invokable<?, ?> in) {
            return in.isAnnotationPresent(PreDestroy.class);
        }
    };
    private static final Predicate<Invokable<?, ?>> isPostConstruct = new Predicate<Invokable<?, ?>>(){

        @Override
        public boolean apply(Invokable<?, ?> in) {
            return in.isAnnotationPresent(PostConstruct.class);
        }
    };

    @Override
    protected void configure() {
        Closeable executorCloser = new Closeable(){
            @Inject
            @Named(value="jclouds.user-threads")
            ListeningExecutorService userExecutor;
            @Inject(optional=true)
            @Named(value="jclouds.scheduler-threads")
            ScheduledExecutorService scheduledExecutor;

            @Override
            public void close() throws IOException {
                assert (this.userExecutor != null);
                this.userExecutor.shutdownNow();
                if (this.scheduledExecutor != null) {
                    this.scheduledExecutor.shutdownNow();
                }
            }
        };
        this.binder().requestInjection(executorCloser);
        Closer closer = new Closer();
        closer.addToClose(executorCloser);
        this.bind(Closer.class).toInstance(closer);
        ExecutionList list = new ExecutionList();
        this.bindPostInjectionInvoke(closer, list);
        this.bind(ExecutionList.class).toInstance(list);
    }

    protected void bindPostInjectionInvoke(final Closer closer, final ExecutionList list) {
        this.bindListener(Matchers.any(), new TypeListener(){

            @Override
            public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                Collection<Invokable<I, Object>> methods = Reflection2.methods(injectableType.getRawType());
                for (final Invokable<I, Object> method : Iterables.filter(methods, isPostConstruct)) {
                    encounter.register(new InjectionListener<I>(){

                        @Override
                        public void afterInjection(final I injectee) {
                            list.add(new Runnable(){

                                @Override
                                public void run() {
                                    LifeCycleModule.invokeOnInjectee(method, injectee);
                                }
                            }, MoreExecutors.newDirectExecutorService());
                        }
                    });
                }
                for (final Invokable<I, Object> method : Iterables.filter(methods, isPreDestroy)) {
                    encounter.register(new InjectionListener<I>(){

                        @Override
                        public void afterInjection(final I injectee) {
                            closer.addToClose(new Closeable(){

                                @Override
                                public void close() throws IOException {
                                    LifeCycleModule.invokeOnInjectee(method, injectee);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private static <I> void invokeOnInjectee(Invokable<? super I, Object> method, I injectee) {
        try {
            method.invoke(injectee, new Object[0]);
        }
        catch (InvocationTargetException ie) {
            throw Throwables.propagate(ie.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate(e);
        }
    }
}

