/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.io.payloads;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.io.MutableContentMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.io.Payload;
import java.io.IOException;
import java.io.InputStream;

public class DelegatingPayload
implements Payload {
    private final Payload delegate;
    private boolean isSensitive;

    public DelegatingPayload(Payload delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.delegate.openStream();
    }

    @Override
    public InputStream getInput() {
        try {
            return this.openStream();
        }
        catch (IOException ioe) {
            throw Throwables.propagate(ioe);
        }
    }

    @Override
    public Object getRawContent() {
        return this.delegate.getInput();
    }

    @Override
    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public Payload getDelegate() {
        return this.delegate;
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.delegate.getContentMetadata();
    }

    @Override
    public void setContentMetadata(MutableContentMetadata in) {
        this.delegate.setContentMetadata(in);
    }

    @Override
    public void setSensitive(boolean isSensitive) {
        this.isSensitive = isSensitive;
    }

    @Override
    public boolean isSensitive() {
        return this.isSensitive;
    }
}

