/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpUtils;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.xml.XMLParser;
import java.io.IOException;
import java.io.InputStream;

@Singleton
public class ParseXMLWithJAXB<T>
implements Function<HttpResponse, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected XMLParser xml;
    protected final TypeLiteral<T> type;

    @Inject
    public ParseXMLWithJAXB(XMLParser xml, TypeLiteral<T> type) {
        this.xml = xml;
        this.type = type;
    }

    @Override
    public T apply(HttpResponse from) {
        InputStream xml = from.getPayload().getInput();
        try {
            T t = this.apply(xml);
            return t;
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("Error parsing input");
            this.logger.error(e, message.toString(), new Object[0]);
            throw new HttpResponseException(message.toString() + "\n" + from, null, from, (Throwable)e);
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }

    @Override
    public T apply(InputStream stream) throws IOException {
        return this.apply(stream, this.type.getRawType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V apply(InputStream stream, Class<V> type) throws IOException {
        try {
            String str = Strings2.toStringAndClose(stream);
            V v = this.xml.fromXML(str, type);
            return v;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

