/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpUtils;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.Uris;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.InvocationContext;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.io.IOException;
import java.net.URI;

public class ParseURIFromListOrLocationHeaderIf20x
implements Function<HttpResponse, URI>,
InvocationContext<ParseURIFromListOrLocationHeaderIf20x> {
    protected HttpRequest request;

    @Override
    public URI apply(HttpResponse from) {
        if (from.getStatusCode() > 206) {
            throw new HttpException(String.format("Unhandled status code  - %1$s", from));
        }
        if ("text/uri-list".equals(from.getFirstHeaderOrNull("Content-Type"))) {
            try {
                if (from.getPayload().getInput() == null) {
                    throw new HttpResponseException("no content", null, from);
                }
                String toParse = Strings2.toStringAndClose(from.getPayload().getInput());
                URI uRI = URI.create(toParse.trim());
                return uRI;
            }
            catch (IOException e) {
                throw new HttpResponseException("couldn't parse uri from content", null, from, (Throwable)e);
            }
            finally {
                HttpUtils.releasePayload(from);
            }
        }
        HttpUtils.releasePayload(from);
        String location = from.getFirstHeaderOrNull("Location");
        if (location == null) {
            location = from.getFirstHeaderOrNull("location");
        }
        if (location != null) {
            URI locationUri = URI.create(location);
            if (locationUri.getHost() != null) {
                return locationUri;
            }
            Preconditions.checkState(this.request != null, "request should have been initialized");
            if (!location.startsWith("/")) {
                location = "/" + location;
            }
            locationUri = URI.create(location);
            return Uris.uriBuilder(this.request.getEndpoint()).path(locationUri.getPath()).query(locationUri.getQuery()).build();
        }
        return null;
    }

    @Override
    public ParseURIFromListOrLocationHeaderIf20x setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

