/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api.support;

import io.ebean.FetchPath;
import io.ebean.text.PathProperties;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class DocStructure {
    private final PathProperties doc;
    private final Map<String, PathProperties> embedded = new HashMap<String, PathProperties>();
    private final Map<String, PathProperties> manyRoot = new HashMap<String, PathProperties>();

    public DocStructure(PathProperties pathProps) {
        this.doc = pathProps;
    }

    public void addProperty(String name) {
        this.doc.addToPath(null, name);
    }

    public void addNested(String path, PathProperties embeddedDoc) {
        this.doc.addNested(path, embeddedDoc);
        this.embedded.put(path, embeddedDoc);
    }

    public PathProperties doc() {
        return this.doc;
    }

    public FetchPath embedded(String path) {
        return (FetchPath)this.embedded.get(path);
    }

    public FetchPath embeddedManyRoot(String path) {
        return (FetchPath)this.manyRoot.get(path);
    }

    public <T> void prepareMany(BeanDescriptor<T> desc) {
        Set<String> strings = this.embedded.keySet();
        for (String prop : strings) {
            BeanPropertyAssoc embProp = (BeanPropertyAssoc)desc.findProperty(prop);
            if (!embProp.isMany()) continue;
            this.prepare(prop, embProp);
        }
    }

    private void prepare(String prop, BeanPropertyAssoc<?> embProp) {
        BeanDescriptor<?> targetDesc = embProp.targetDescriptor();
        PathProperties manyRootPath = new PathProperties();
        manyRootPath.addToPath(null, targetDesc.idProperty().name());
        manyRootPath.addNested(prop, this.embedded.get(prop));
        this.manyRoot.put(prop, manyRootPath);
    }
}

