/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarTypeUtils;
import io.ebeaninternal.server.type.ScalarTypeUUIDBase;
import java.sql.SQLException;
import java.util.UUID;

public final class ScalarTypeUUIDBinary
extends ScalarTypeUUIDBase {
    private final boolean optimized;

    ScalarTypeUUIDBinary(boolean optimized) {
        super(false, -2);
        this.optimized = optimized;
    }

    public int length() {
        return 16;
    }

    @Override
    public Object toJdbcType(Object value) {
        return ScalarTypeUUIDBinary.convertToBytes((UUID)value, this.optimized);
    }

    @Override
    public UUID toBeanType(Object value) {
        if (value instanceof byte[]) {
            return ScalarTypeUUIDBinary.convertFromBytes((byte[])value, this.optimized);
        }
        return BasicTypeConverter.toUUID((Object)value, (boolean)this.optimized);
    }

    public void bind(DataBinder binder, UUID value) throws SQLException {
        if (value == null) {
            binder.setNull(-2);
        } else {
            binder.setBytes(ScalarTypeUUIDBinary.convertToBytes(value, this.optimized));
        }
    }

    public UUID read(DataReader reader) throws SQLException {
        byte[] bytes = reader.getBytes();
        if (bytes == null) {
            return null;
        }
        return ScalarTypeUtils.uuidFromBytes((byte[])bytes, (boolean)this.optimized);
    }

    static UUID convertFromBytes(byte[] bytes, boolean optimized) {
        return ScalarTypeUtils.uuidFromBytes((byte[])bytes, (boolean)optimized);
    }

    static byte[] convertToBytes(UUID value, boolean optimized) {
        return ScalarTypeUtils.uuidToBytes((UUID)value, (boolean)optimized);
    }
}

