/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.annotation.DocStoreMode;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cluster.ClusterManager;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.transaction.BeanPersistIdMap;
import io.ebeaninternal.server.transaction.BeanPersistIds;
import io.ebeaninternal.server.transaction.BulkEventListenerMap;
import io.ebeaninternal.server.transaction.DeleteByIdMap;
import io.ebeaninternal.server.transaction.RemoteTableMod;
import io.ebeaninternal.server.transaction.RemoteTransactionEvent;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeanservice.docstore.api.DocStoreUpdates;
import java.util.List;
import java.util.Set;

final class PostCommitProcessing {
    private static final System.Logger log = CoreLog.internal;
    private final ClusterManager clusterManager;
    private final TransactionEvent event;
    private final String serverName;
    private final TransactionManager manager;
    private final List<PersistRequestBean<?>> listenerNotify;
    private final RemoteTransactionEvent remoteTransactionEvent;
    private final DeleteByIdMap deleteByIdMap;
    private final DocStoreMode txnDocStoreMode;
    private final int txnDocStoreBatchSize;

    PostCommitProcessing(ClusterManager clusterManager, TransactionManager manager, TransactionEvent event) {
        this.clusterManager = clusterManager;
        this.manager = manager;
        this.serverName = manager.name();
        this.txnDocStoreMode = DocStoreMode.IGNORE;
        this.txnDocStoreBatchSize = 0;
        this.event = event;
        this.deleteByIdMap = event.getDeleteByIdMap();
        this.listenerNotify = event.getListenerNotify();
        this.remoteTransactionEvent = this.createRemoteTransactionEvent();
    }

    PostCommitProcessing(ClusterManager clusterManager, TransactionManager manager, SpiTransaction transaction) {
        this.clusterManager = clusterManager;
        this.manager = manager;
        this.serverName = manager.name();
        this.txnDocStoreMode = transaction.getDocStoreMode();
        this.txnDocStoreBatchSize = transaction.getDocStoreBatchSize();
        this.event = transaction.getEvent();
        this.deleteByIdMap = this.event.getDeleteByIdMap();
        this.listenerNotify = this.event.getListenerNotify();
        this.remoteTransactionEvent = this.createRemoteTransactionEvent();
    }

    void notifyLocalCache() {
        if (this.manager.notifyL2CacheInForeground) {
            this.processCacheChanges();
        }
    }

    private void processDocStoreUpdates() {
        if (this.isDocStoreUpdate()) {
            DocStoreUpdates docStoreUpdates = new DocStoreUpdates();
            this.event.addDocStoreUpdates(docStoreUpdates);
            if (this.deleteByIdMap != null) {
                this.deleteByIdMap.addDocStoreUpdates(docStoreUpdates, this.txnDocStoreMode);
            }
            if (!docStoreUpdates.isEmpty()) {
                this.manager.processDocStoreUpdates(docStoreUpdates, this.txnDocStoreBatchSize);
            }
        }
    }

    private boolean isDocStoreUpdate() {
        return this.manager.isDocStoreActive() && (this.txnDocStoreMode == null || this.txnDocStoreMode != DocStoreMode.IGNORE);
    }

    private void notifyCluster() {
        if (this.remoteTransactionEvent != null && !this.remoteTransactionEvent.isEmpty()) {
            if (log.isLoggable(System.Logger.Level.DEBUG)) {
                log.log(System.Logger.Level.DEBUG, "Cluster Send: {0}", this.remoteTransactionEvent);
            }
            this.clusterManager.broadcast(this.remoteTransactionEvent);
        }
    }

    Runnable backgroundNotify() {
        return () -> {
            if (!this.manager.notifyL2CacheInForeground) {
                this.processCacheChanges();
            }
            this.localPersistListenersNotify();
            this.notifyCluster();
            this.processDocStoreUpdates();
        };
    }

    private void processCacheChanges() {
        CacheChangeSet cacheChanges = this.event.buildCacheChanges(this.manager);
        if (cacheChanges != null) {
            Set<String> touched = cacheChanges.touchedTables();
            if (touched != null && !touched.isEmpty()) {
                this.manager.processTouchedTables(touched);
                if (this.remoteTransactionEvent != null) {
                    this.remoteTransactionEvent.addRemoteTableMod(new RemoteTableMod(touched));
                }
            }
            cacheChanges.apply();
        }
    }

    private void localPersistListenersNotify() {
        TransactionEventTable eventTables;
        if (this.listenerNotify != null) {
            for (PersistRequestBean<?> request : this.listenerNotify) {
                request.notifyLocalPersistListener();
            }
        }
        if ((eventTables = this.event.getEventTables()) != null && !eventTables.isEmpty()) {
            BulkEventListenerMap map = this.manager.bulkEventListenerMap();
            for (TransactionEventTable.TableIUD tableIUD : eventTables.values()) {
                map.process(tableIUD);
            }
        }
    }

    private BeanPersistIdMap createBeanPersistIdMap() {
        if (this.listenerNotify == null) {
            return null;
        }
        BeanPersistIdMap m = new BeanPersistIdMap();
        for (PersistRequestBean<?> request : this.listenerNotify) {
            request.addToPersistMap(m);
        }
        return m;
    }

    private RemoteTransactionEvent createRemoteTransactionEvent() {
        TransactionEventTable eventTables;
        if (!this.clusterManager.isClustering()) {
            return null;
        }
        RemoteTransactionEvent remoteTransactionEvent = new RemoteTransactionEvent(this.serverName);
        BeanPersistIdMap beanPersistIdMap = this.createBeanPersistIdMap();
        if (beanPersistIdMap != null) {
            for (BeanPersistIds beanPersist : beanPersistIdMap.values()) {
                remoteTransactionEvent.addBeanPersistIds(beanPersist);
            }
        }
        if (this.deleteByIdMap != null) {
            remoteTransactionEvent.setDeleteByIdMap(this.deleteByIdMap);
        }
        if ((eventTables = this.event.getEventTables()) != null && !eventTables.isEmpty()) {
            for (TransactionEventTable.TableIUD tableIUD : eventTables.values()) {
                remoteTransactionEvent.addTableIUD(tableIUD);
            }
        }
        return remoteTransactionEvent;
    }
}

