/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeCommon;
import io.ebeaninternal.server.query.SqlTreeLoad;
import io.ebeaninternal.server.query.SqlTreeLoadRoot;
import io.ebeaninternal.server.query.SqlTreeNode;
import io.ebeaninternal.server.query.SqlTreeNodeBean;
import io.ebeaninternal.server.query.SqlTreeProperties;
import java.util.List;
import java.util.Set;

final class SqlTreeNodeRoot
extends SqlTreeNodeBean {
    private final TableJoin includeJoin;
    private final boolean sqlDistinct;
    private final String baseTable;

    SqlTreeNodeRoot(STreeType desc, SqlTreeProperties props, List<SqlTreeNode> myList, boolean withId, STreePropertyAssocMany many, SqlTreeCommon common, boolean sqlDistinct, String baseTable) {
        super(desc, props, myList, withId, many, common);
        this.includeJoin = common.includeJoin();
        this.sqlDistinct = sqlDistinct;
        this.baseTable = baseTable;
    }

    @Override
    public SqlTreeLoad createLoad() {
        return new SqlTreeLoadRoot(this);
    }

    @Override
    public boolean isSqlDistinct() {
        return this.sqlDistinct;
    }

    @Override
    public void appendDistinctOn(DbSqlContext ctx, boolean subQuery) {
        if (this.readId) {
            ctx.pushTableAlias(this.prefix);
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
            ctx.popTableAlias();
            super.appendDistinctOn(ctx, subQuery);
        }
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
        if (this.desc.isHistorySupport()) {
            query.setAsOfBaseTable();
        }
    }

    @Override
    public SqlJoinType appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        ctx.append(this.baseTable);
        ctx.append(" ").append(this.baseTableAlias);
        ctx.appendFromForUpdate();
        if (this.includeJoin != null) {
            String a1 = this.baseTableAlias;
            String a2 = "int_";
            this.includeJoin.addJoin(joinType, a1, a2, ctx);
        }
        return joinType;
    }

    @Override
    public void dependentTables(Set<String> tables) {
        for (SqlTreeNode child : this.children) {
            child.dependentTables(tables);
        }
    }
}

