/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dmlbind;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableRequest;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

final class BindableEmbedded
implements Bindable {
    private final Bindable[] items;
    private final BeanPropertyAssocOne<?> embProp;

    BindableEmbedded(BeanPropertyAssocOne<?> embProp, List<Bindable> bindList) {
        this.embProp = embProp;
        this.items = bindList.toArray(new Bindable[0]);
    }

    public String toString() {
        return "BindableEmbedded " + String.valueOf(this.embProp) + " items:" + Arrays.toString(this.items);
    }

    @Override
    public boolean isDraftOnly() {
        return this.embProp.isDraftOnly();
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        for (Bindable item : this.items) {
            item.dmlAppend(request);
        }
    }

    @Override
    public void addToUpdate(PersistRequestBean<?> request, List<Bindable> list) {
        if (request.isAddToUpdate(this.embProp)) {
            list.add(this);
        }
    }

    @Override
    public void dmlBind(BindableRequest bindRequest, EntityBean bean) throws SQLException {
        EntityBean embBean = (EntityBean)this.embProp.getValue(bean);
        if (embBean == null) {
            for (Bindable item : this.items) {
                item.dmlBind(bindRequest, null);
            }
        } else {
            for (Bindable item : this.items) {
                item.dmlBind(bindRequest, embBean);
            }
        }
    }
}

