/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.logger;

import io.ebeaninternal.api.SpiLogger;
import io.ebeaninternal.api.SpiTxnLogger;
import io.ebeaninternal.server.util.Str;

final class DTxnLogger
implements SpiTxnLogger {
    private final String id;
    private final String logPrefix;
    private final SpiLogger sql;
    private final SpiLogger sum;
    private final SpiLogger txn;

    DTxnLogger(String id, SpiLogger sql, SpiLogger sum, SpiLogger txn) {
        this.id = id;
        this.logPrefix = id == null ? "" : "txn[" + id + "] ";
        this.sql = sql;
        this.sum = sum;
        this.txn = txn;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean isLogSql() {
        return this.sql.isDebug();
    }

    @Override
    public boolean isLogSummary() {
        return this.sum.isDebug();
    }

    @Override
    public void sql(String msg, Object ... args) {
        this.sql.debug(Str.add(this.logPrefix, msg), args);
    }

    @Override
    public void sum(String msg, Object ... args) {
        this.sum.debug(Str.add(this.logPrefix, msg), args);
    }

    @Override
    public void txn(String msg, Object ... args) {
        this.txn.debug(Str.add(this.logPrefix, msg), args);
    }

    @Override
    public void notifyCommit() {
        this.txn.debug(Str.add(this.logPrefix, "Commit"), new Object[0]);
    }

    @Override
    public void notifyQueryOnly() {
    }

    @Override
    public void notifyRollback(Throwable cause) {
        if (this.txn.isDebug()) {
            String msg = this.logPrefix + "Rollback";
            if (cause != null) {
                msg = msg + " error: " + this.formatThrowable(cause);
            }
            this.txn.debug(msg, new Object[0]);
        }
    }

    private String formatThrowable(Throwable e) {
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.formatThrowable(e, sb);
        return sb.toString();
    }

    private void formatThrowable(Throwable e, StringBuilder sb) {
        Throwable cause;
        sb.append(e.toString());
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            sb.append(" stack0: ");
            sb.append(stackTrace[0]);
        }
        if ((cause = e.getCause()) != null) {
            sb.append(" cause: ");
            this.formatThrowable(cause, sb);
        }
    }
}

