/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

final class ArrayIsEmptyExpression
extends AbstractExpression {
    private final boolean empty;

    ArrayIsEmptyExpression(String propName, boolean empty) {
        super(propName);
        this.empty = empty;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeExists(!this.empty, this.propName);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.empty) {
            builder.append("ArrayIsEmpty[");
        } else {
            builder.append("ArrayIsNotEmpty[");
        }
        builder.append(this.propName).append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.empty);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        return true;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.platformHandler().arrayIsEmpty(request, this.propName, this.empty);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }
}

