/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.ValuePair;
import io.ebean.annotation.DocStoreMode;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PreGetterCallback;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistListener;
import io.ebean.event.BeanPersistRequest;
import io.ebean.event.changelog.BeanChange;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.core.PersistDeferredRelationship;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanManager;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.BatchedSqlException;
import io.ebeaninternal.server.persist.DeleteMode;
import io.ebeaninternal.server.persist.Flags;
import io.ebeaninternal.server.persist.PersistExecute;
import io.ebeaninternal.server.persist.SaveMany;
import io.ebeaninternal.server.transaction.BeanPersistIdMap;
import io.ebeanservice.docstore.api.DocStoreUpdate;
import io.ebeanservice.docstore.api.DocStoreUpdateContext;
import io.ebeanservice.docstore.api.DocStoreUpdates;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;

public final class PersistRequestBean<T>
extends PersistRequest
implements BeanPersistRequest<T>,
DocStoreUpdate,
PreGetterCallback,
SpiProfileTransactionEvent {
    private final BeanManager<T> beanManager;
    private final BeanDescriptor<T> beanDescriptor;
    private final BeanPersistListener beanPersistListener;
    private final BeanPersistController controller;
    private final T bean;
    private final EntityBean entityBean;
    private final EntityBeanIntercept intercept;
    private final Object parentBean;
    private final boolean dirty;
    private final boolean publish;
    private int flags;
    private boolean saveRecurse;
    private DocStoreMode docStoreMode;
    private final ConcurrencyMode concurrencyMode;
    private Object idValue;
    private Integer beanHash;
    private boolean statelessUpdate;
    private boolean notifyCache;
    private boolean updatedManysOnly;
    private Map<String, Object> collectionChanges;
    private boolean updatedMany;
    private List<BeanPropertyAssocMany<?>> updatedManys;
    private Set<String> updatedProperties;
    private boolean[] dirtyProperties;
    private EntityBean orphanBean;
    private boolean batched;
    private boolean skipBatchForTopLevel;
    private boolean batchOnCascadeSet;
    private boolean requestUpdateAllLoadedProps;
    private long version;
    private long now;
    private long profileOffset;
    private boolean getterCallback;
    private boolean pendingPostUpdateNotify;
    private boolean postExecute;
    private boolean complete;
    private List<SaveMany> saveMany;

    public PersistRequestBean(SpiEbeanServer server, T bean, Object parentBean, BeanManager<T> mgr, SpiTransaction t, PersistExecute persistExecute, PersistRequest.Type type, int flags) {
        super(server, t, persistExecute);
        this.entityBean = (EntityBean)bean;
        this.intercept = this.entityBean._ebean_getIntercept();
        this.beanManager = mgr;
        this.beanDescriptor = mgr.getBeanDescriptor();
        this.beanPersistListener = this.beanDescriptor.persistListener();
        this.bean = bean;
        this.parentBean = parentBean;
        this.controller = this.beanDescriptor.persistController();
        this.type = type;
        this.docStoreMode = this.calcDocStoreMode(this.transaction, type);
        this.flags = flags;
        if (Flags.isRecurse(flags)) {
            this.persistCascade = t.isPersistCascade();
        }
        if (this.type == PersistRequest.Type.UPDATE) {
            if (this.intercept.isNew()) {
                this.intercept.setNewBeanForUpdate();
                this.statelessUpdate = true;
            } else if (!this.intercept.isDirty()) {
                this.beanDescriptor.checkAnyMutableProperties(this.intercept);
            }
        }
        this.concurrencyMode = this.beanDescriptor.concurrencyMode(this.intercept);
        this.publish = Flags.isPublish(flags);
        if (this.isMarkDraftDirty(this.publish)) {
            this.beanDescriptor.setDraftDirty(this.entityBean, true);
        }
        this.dirty = this.intercept.isDirty();
    }

    public void initForSoftDelete() {
        this.initGeneratedProperties();
    }

    @Override
    public void addTimingBatch(long startNanos, int batch) {
        this.beanDescriptor.metricPersistBatch(this.type, startNanos, batch);
    }

    @Override
    public void addTimingNoBatch(long startNanos) {
        this.beanDescriptor.metricPersistNoBatch(this.type, startNanos);
    }

    @Override
    public void profile(long offset, int flushCount) {
        this.profileBase(this.type.profileEventId, offset, this.beanDescriptor.name(), flushCount);
    }

    private DocStoreMode calcDocStoreMode(SpiTransaction txn, PersistRequest.Type type) {
        DocStoreMode txnMode = txn == null ? null : txn.getDocStoreMode();
        return this.beanDescriptor.docStoreMode(type, txnMode);
    }

    public boolean isCascade() {
        return Flags.isRecurse(this.flags);
    }

    private boolean isMarkDraftDirty(boolean publish) {
        return !publish && this.type != PersistRequest.Type.DELETE && this.beanDescriptor.isDraftable();
    }

    public void setTrans(SpiTransaction transaction) {
        this.transaction = transaction;
        this.createdTransaction = false;
        this.persistCascade = transaction.isPersistCascade();
    }

    public void initTransIfRequiredWithBatchCascade() {
        if (this.createImplicitTransIfRequired()) {
            this.docStoreMode = this.calcDocStoreMode(this.transaction, this.type);
        }
        this.checkBatchEscalationOnCascade();
    }

    public void checkBatchEscalationOnCascade() {
        if ((this.type == PersistRequest.Type.UPDATE || this.beanDescriptor.isBatchEscalateOnCascade(this.type)) && this.transaction.checkBatchEscalationOnCascade(this)) {
            this.batchOnCascadeSet = !this.createdTransaction;
        }
        this.persistCascade = this.transaction.isPersistCascade();
    }

    private void initGeneratedProperties() {
        switch (this.type) {
            case INSERT: {
                this.onInsertGeneratedProperties();
                break;
            }
            case UPDATE: {
                if (this.beanDescriptor.isReference(this.intercept) || !this.dirty && !this.statelessUpdate) break;
                this.onUpdateGeneratedProperties();
                break;
            }
            case DELETE_SOFT: {
                this.onUpdateGeneratedProperties();
            }
        }
    }

    private void onUpdateGeneratedProperties() {
        for (BeanProperty prop : this.beanDescriptor.propertiesGenUpdate()) {
            GeneratedProperty generatedProperty = prop.generatedProperty();
            if (prop.isVersion()) {
                if (!this.isLoadedProperty(prop)) continue;
                Object value = generatedProperty.getUpdateValue(prop, this.entityBean, this.now());
                Object oldVal = prop.getValue(this.entityBean);
                this.setVersionValue(value);
                this.intercept.setOldValue(prop.propertyIndex(), oldVal);
                continue;
            }
            Object oldVal = prop.getValue(this.entityBean);
            Object value = generatedProperty.getUpdateValue(prop, this.entityBean, this.now());
            prop.setValueChanged(this.entityBean, value);
            this.intercept.setOldValue(prop.propertyIndex(), oldVal);
        }
    }

    private void onFailedUpdateUndoGeneratedProperties() {
        for (BeanProperty prop : this.beanDescriptor.propertiesGenUpdate()) {
            Object oldVal = this.intercept.origValue(prop.propertyIndex());
            prop.setValue(this.entityBean, oldVal);
        }
    }

    private void onInsertGeneratedProperties() {
        for (BeanProperty prop : this.beanDescriptor.propertiesGenInsert()) {
            Object value = prop.generatedProperty().getInsertValue(prop, this.entityBean, this.now());
            prop.setValueChanged(this.entityBean, value);
        }
    }

    public void flushBatchOnCascade() {
        if (this.batchOnCascadeSet) {
            this.transaction.flushBatchOnCascade();
            this.batchOnCascadeSet = false;
        }
    }

    @Override
    public void rollbackTransIfRequired() {
        if (this.batchOnCascadeSet) {
            this.transaction.flushBatchOnRollback();
            this.batchOnCascadeSet = false;
        }
        super.rollbackTransIfRequired();
    }

    public boolean isBatched() {
        return this.batched;
    }

    public void setBatched() {
        this.batched = true;
        if ((this.type == PersistRequest.Type.INSERT || this.type == PersistRequest.Type.UPDATE) && this.beanDescriptor.hasSingleIdProperty()) {
            this.intercept.registerGetterCallback((PreGetterCallback)this);
            this.getterCallback = true;
        }
    }

    public void preGetterTrigger(int propertyIndex) {
        if (this.flushBatchOnGetter(propertyIndex)) {
            this.transaction.flush();
        }
    }

    private boolean flushBatchOnGetter(int propertyIndex) {
        if (propertyIndex == -1) {
            if (this.beanDescriptor.isIdLoaded(this.intercept)) {
                return false;
            }
            return this.type == PersistRequest.Type.INSERT;
        }
        return this.beanDescriptor.isGeneratedProperty(propertyIndex);
    }

    public void setSkipBatchForTopLevel() {
        this.skipBatchForTopLevel = true;
    }

    @Override
    public boolean isBatchThisRequest() {
        return !this.skipBatchForTopLevel && super.isBatchThisRequest();
    }

    public boolean isInsert() {
        return PersistRequest.Type.INSERT == this.type;
    }

    public Set<String> loadedProperties() {
        return this.intercept.loadedPropertyNames();
    }

    public Set<String> updatedProperties() {
        return this.intercept.dirtyPropertyNames();
    }

    public boolean[] dirtyProperties() {
        return this.dirtyProperties;
    }

    public boolean hasDirtyProperty(Set<String> propertyNames) {
        return this.intercept.hasDirtyProperty(propertyNames);
    }

    public boolean hasDirtyProperty(int[] propertyPositions) {
        for (int propertyPosition : propertyPositions) {
            if (!this.dirtyProperties[propertyPosition]) continue;
            return true;
        }
        return false;
    }

    public Map<String, ValuePair> updatedValues() {
        return this.intercept.dirtyValues();
    }

    private void setNotifyCache() {
        this.notifyCache = this.beanDescriptor.isCacheNotify(this.type, this.publish);
    }

    private boolean isNotifyListeners() {
        return this.isNotifyPersistListener() || this.isDocStoreNotify();
    }

    private boolean isDocStoreNotify() {
        return this.docStoreMode != DocStoreMode.IGNORE;
    }

    private boolean isNotifyPersistListener() {
        return this.beanPersistListener != null;
    }

    private void notifyCache(CacheChangeSet changeSet) {
        if (this.notifyCache) {
            switch (this.type) {
                case INSERT: {
                    this.beanDescriptor.cachePersistInsert(this, changeSet);
                    break;
                }
                case UPDATE: {
                    this.beanDescriptor.cachePersistUpdate(this.idValue, this, changeSet);
                    break;
                }
                case DELETE_SOFT: 
                case DELETE: {
                    this.beanDescriptor.cachePersistDelete(this.idValue, this, changeSet);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type " + String.valueOf((Object)this.type));
                }
            }
        }
    }

    @Override
    public void docStoreUpdate(DocStoreUpdateContext txn) throws IOException {
        switch (this.type) {
            case INSERT: {
                this.beanDescriptor.docStoreInsert(this.idValue, this, txn);
                break;
            }
            case UPDATE: 
            case DELETE_SOFT: {
                this.beanDescriptor.docStoreUpdate(this.idValue, this, txn);
                break;
            }
            case DELETE: {
                this.beanDescriptor.docStoreDeleteById(this.idValue, txn);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type " + String.valueOf((Object)this.type));
            }
        }
    }

    @Override
    public void addToQueue(DocStoreUpdates docStoreUpdates) {
        switch (this.type) {
            case INSERT: 
            case UPDATE: 
            case DELETE_SOFT: {
                docStoreUpdates.queueIndex(this.beanDescriptor.docStoreQueueId(), this.idValue);
                break;
            }
            case DELETE: {
                docStoreUpdates.queueDelete(this.beanDescriptor.docStoreQueueId(), this.idValue);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type " + String.valueOf((Object)this.type));
            }
        }
    }

    public void addToPersistMap(BeanPersistIdMap beanPersistMap) {
        beanPersistMap.add(this.beanDescriptor, this.type, this.idValue);
    }

    public void notifyLocalPersistListener() {
        if (this.beanPersistListener != null) {
            switch (this.type) {
                case INSERT: {
                    this.beanPersistListener.inserted(this.bean);
                    break;
                }
                case UPDATE: {
                    this.beanPersistListener.updated(this.bean, this.updatedProperties);
                    break;
                }
                case DELETE: {
                    this.beanPersistListener.deleted(this.bean);
                    break;
                }
                case DELETE_SOFT: {
                    this.beanPersistListener.softDeleted(this.bean);
                    break;
                }
            }
        }
    }

    public boolean isParent(Object o) {
        return o == this.parentBean;
    }

    public boolean isRegisteredBean() {
        return this.transaction.isRegisteredBean(this.bean);
    }

    public void unRegisterBean() {
        if (!this.saveRecurse) {
            this.transaction.unregisterBeans();
        }
    }

    private Integer getBeanHash() {
        if (this.beanHash == null) {
            Object id = this.beanDescriptor.getId(this.entityBean);
            int hc = 92821 * this.bean.getClass().getName().hashCode();
            if (id != null) {
                hc += id.hashCode();
            }
            this.beanHash = hc;
        }
        return this.beanHash;
    }

    public void registerDeleteBean() {
        Integer hash = this.getBeanHash();
        this.transaction.registerDeleteBean(hash);
    }

    public boolean isRegisteredForDeleteBean() {
        if (this.transaction == null) {
            return false;
        }
        Integer hash = this.getBeanHash();
        return this.transaction.isRegisteredDeleteBean(hash);
    }

    public BeanDescriptor<T> descriptor() {
        return this.beanDescriptor;
    }

    private void postControllerPrepareUpdate() {
        if (this.statelessUpdate && this.controller != null) {
            this.intercept.setNewBeanForUpdate();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ConcurrencyMode concurrencyMode() {
        return this.concurrencyMode;
    }

    public String fullName() {
        return this.beanDescriptor.fullName();
    }

    public T bean() {
        return this.bean;
    }

    public EntityBean entityBean() {
        return this.entityBean;
    }

    public Object beanId() {
        return this.beanDescriptor.getId(this.entityBean);
    }

    public T createReference() {
        return this.beanDescriptor.createRef(this.beanId(), null);
    }

    public boolean isDraftable() {
        return this.beanDescriptor.isDraftable();
    }

    public boolean isHardDeleteDraft() {
        if (this.type == PersistRequest.Type.DELETE && this.beanDescriptor.isDraftable() && !this.beanDescriptor.isDraftableElement()) {
            if (this.beanDescriptor.isLiveInstance(this.entityBean)) {
                throw new PersistenceException("Explicit Delete is not allowed on a 'live' bean - only draft beans");
            }
            return true;
        }
        return false;
    }

    public boolean isHardDeleteCascade() {
        return this.type == PersistRequest.Type.DELETE && this.beanDescriptor.isSoftDelete();
    }

    public void checkDraft() {
        if (this.beanDescriptor.isDraftable() && this.beanDescriptor.isLiveInstance(this.entityBean)) {
            throw new PersistenceException("Save or update is not allowed on a 'live' bean - only draft beans");
        }
    }

    public Object parentBean() {
        return this.parentBean;
    }

    public EntityBeanIntercept intercept() {
        return this.intercept;
    }

    public boolean isLoadedProperty(BeanProperty prop) {
        return this.intercept.isLoadedProperty(prop.propertyIndex());
    }

    public boolean isDirtyProperty(BeanProperty prop) {
        return this.intercept.isDirtyProperty(prop.propertyIndex());
    }

    public Object getOrigValue(BeanProperty prop) {
        return this.intercept.origValue(prop.propertyIndex());
    }

    @Override
    public int executeNow() {
        if (this.getterCallback) {
            this.intercept.clearGetterCallback();
        }
        switch (this.type) {
            case INSERT: {
                this.executeInsert();
                return -1;
            }
            case UPDATE: {
                this.executeUpdate();
                return -1;
            }
            case DELETE_SOFT: {
                this.prepareForSoftDelete();
                this.executeSoftDelete();
                return -1;
            }
            case DELETE: {
                return this.executeDelete();
            }
        }
        throw new RuntimeException("Invalid type " + String.valueOf((Object)this.type));
    }

    private void prepareForSoftDelete() {
        this.beanDescriptor.softDeleteValue(this.entityBean);
    }

    @Override
    public int executeOrQueue() {
        boolean batch = this.isBatchThisRequest();
        try {
            BatchControl control = this.transaction.getBatchControl();
            if (control != null) {
                return control.executeOrQueue(this, batch);
            }
            if (batch) {
                control = this.persistExecute.createBatchControl(this.transaction);
                return control.executeOrQueue(this, true);
            }
            return this.executeNoBatch();
        }
        catch (BatchedSqlException e) {
            throw this.transaction.translate(e.getMessage(), e.getCause());
        }
    }

    private int executeNoBatch() {
        this.profileOffset = this.transaction.profileOffset();
        int result = this.executeNow();
        this.transaction.profileEvent(this);
        return result;
    }

    @Override
    public void setGeneratedKey(Object idValue) {
        if (idValue != null) {
            this.idValue = this.beanDescriptor.convertSetId(idValue, this.entityBean);
        }
    }

    public void setBoundId(Object idValue) {
        this.idValue = idValue;
    }

    @Override
    public void checkRowCount(int rowCount) {
        if (rowCount != 1 && rowCount != -2) {
            if (ConcurrencyMode.VERSION == this.concurrencyMode) {
                this.onFailedUpdateUndoGeneratedProperties();
                throw new OptimisticLockException("Data has changed. updated row count " + rowCount, null, this.bean);
            }
            if (rowCount == 0 && this.type == PersistRequest.Type.UPDATE) {
                throw new EntityNotFoundException("No rows updated");
            }
        }
        switch (this.type) {
            case DELETE_SOFT: 
            case DELETE: {
                this.postDelete();
                break;
            }
            case UPDATE: {
                this.postUpdate();
                break;
            }
        }
    }

    private void postUpdate() {
        if (this.statelessUpdate) {
            this.beanDescriptor.contextClear(this.transaction.getPersistenceContext(), this.idValue);
        }
    }

    private void postUpdateNotify() {
        if (this.pendingPostUpdateNotify) {
            this.controller.postUpdate((BeanPersistRequest)this);
        }
    }

    public void removeFromPersistenceContext() {
        this.idValue = this.beanDescriptor.getId(this.entityBean);
        this.beanDescriptor.contextDeleted(this.transaction.getPersistenceContext(), this.idValue);
    }

    private void postDelete() {
        this.beanDescriptor.contextClear(this.transaction.getPersistenceContext(), this.idValue);
    }

    private void changeLog() {
        BeanChange changeLogBean = this.beanDescriptor.changeLogBean(this);
        if (changeLogBean != null) {
            this.transaction.addBeanChange(changeLogBean);
        }
    }

    @Override
    public void postExecute() {
        this.saveQueuedMany();
        this.postExecute = true;
        if (this.controller != null) {
            this.controllerPost();
        }
        this.setNotifyCache();
        boolean isChangeLog = this.beanDescriptor.isChangeLog();
        if (this.type == PersistRequest.Type.UPDATE && (isChangeLog || this.notifyCache || this.docStoreMode == DocStoreMode.UPDATE)) {
            this.dirtyProperties = this.intercept.dirtyProperties();
        }
        if (isChangeLog) {
            this.changeLog();
        }
        this.intercept.setLoaded();
        if (this.isInsert()) {
            this.postInsert();
        }
        this.addPostCommitListeners();
        this.notifyCacheOnPostExecute();
        if (this.logSummary()) {
            this.logSummaryMessage();
        }
    }

    private void saveQueuedMany() {
        if (this.saveMany != null) {
            this.saveMany.forEach(SaveMany::saveBatch);
        }
    }

    public void preElementCollectionUpdate() {
        if (this.controller != null && !this.dirty) {
            this.controller.preUpdate((BeanPersistRequest)this);
            this.pendingPostUpdateNotify = true;
        }
        if (!this.dirty) {
            this.setNotifyCache();
        }
    }

    public boolean isNotifyCache() {
        return this.notifyCache;
    }

    private void controllerPost() {
        switch (this.type) {
            case INSERT: {
                this.controller.postInsert((BeanPersistRequest)this);
                break;
            }
            case UPDATE: {
                this.controller.postUpdate((BeanPersistRequest)this);
                break;
            }
            case DELETE_SOFT: {
                this.controller.postSoftDelete((BeanPersistRequest)this);
                break;
            }
            case DELETE: {
                this.controller.postDelete((BeanPersistRequest)this);
                break;
            }
        }
    }

    private void logSummaryMessage() {
        String draft = this.beanDescriptor.isDraftable() && !this.publish ? " draft[true]" : "";
        String name = this.beanDescriptor.name();
        switch (this.type) {
            case INSERT: {
                this.transaction.logSummary("Inserted [{0}] [{1}]{2}", name, this.idValue == null ? "" : this.idValue, draft);
                break;
            }
            case UPDATE: {
                this.transaction.logSummary("Updated [{0}] [{1}]{2}", name, this.idValue, draft);
                break;
            }
            case DELETE: {
                this.transaction.logSummary("Deleted [{0}] [{1}]{2}", name, this.idValue, draft);
                break;
            }
            case DELETE_SOFT: {
                this.transaction.logSummary("SoftDelete [{0}] [{1}]{2}", name, this.idValue, draft);
                break;
            }
        }
    }

    private void addPostCommitListeners() {
        TransactionEvent event = this.transaction.getEvent();
        if (event != null && this.isNotifyListeners()) {
            event.addListenerNotify(this);
        }
    }

    public boolean isAddToUpdate(BeanProperty prop) {
        if (this.requestUpdateAllLoadedProps) {
            return this.intercept.isLoadedProperty(prop.propertyIndex());
        }
        return this.intercept.isDirtyProperty(prop.propertyIndex());
    }

    public void deferredRelationship(EntityBean assocBean, ImportedId importedId, EntityBean bean) {
        this.transaction.registerDeferred(new PersistDeferredRelationship(this.server, this.beanDescriptor, assocBean, importedId, bean));
    }

    private void postInsert() {
        this.beanDescriptor.setAllLoaded(this.entityBean);
        if (!this.publish) {
            this.beanDescriptor.setDraft(this.entityBean);
        }
        if (this.transaction.isAutoPersistUpdates() && this.idValue != null) {
            this.beanDescriptor.contextPut(this.transaction.getPersistenceContext(), this.idValue, this.entityBean);
        }
    }

    public boolean isSkipReference() {
        return this.intercept.isReference() || Flags.isRecurse(this.flags) && this.beanDescriptor.referenceIdPropertyOnly(this.intercept);
    }

    public boolean isReference() {
        return this.beanDescriptor.isReference(this.intercept);
    }

    public void setUpdatedMany() {
        this.updatedMany = true;
    }

    public void addUpdatedManyForL2Cache(BeanPropertyAssocMany<?> many) {
        if (this.updatedManys == null) {
            this.updatedManys = new ArrayList(5);
        }
        this.updatedManys.add(many);
    }

    public List<BeanPropertyAssocMany<?>> updatedManyForL2Cache() {
        return this.updatedManys;
    }

    public void complete() {
        this.notifyCacheOnComplete();
    }

    public void completeUpdate() {
        if (!this.dirty && this.updatedMany) {
            if (this.idValue == null) {
                this.idValue = this.beanDescriptor.getId(this.entityBean);
            }
            this.postExecute = true;
            this.updatedManysOnly = true;
            this.setNotifyCache();
            this.addPostCommitListeners();
            this.saveQueuedMany();
        }
        this.notifyCacheOnComplete();
        this.postUpdateNotify();
    }

    private void notifyCacheOnPostExecute() {
        TransactionEvent event;
        this.postExecute = true;
        if (this.notifyCache && this.complete && (event = this.transaction.getEvent()) != null) {
            this.notifyCache(event.obtainCacheChangeSet());
        }
    }

    private void notifyCacheOnComplete() {
        TransactionEvent event;
        this.complete = true;
        if (this.notifyCache && this.postExecute && (event = this.transaction.getEvent()) != null) {
            this.notifyCache(event.obtainCacheChangeSet());
        }
    }

    public void addDocStoreUpdates(DocStoreUpdates docStoreUpdates) {
        if (this.type == PersistRequest.Type.UPDATE) {
            this.beanDescriptor.docStoreUpdateEmbedded(this, docStoreUpdates);
        }
        switch (this.docStoreMode) {
            case UPDATE: {
                docStoreUpdates.addPersist(this);
                return;
            }
            case QUEUE: {
                if (this.type == PersistRequest.Type.DELETE) {
                    docStoreUpdates.queueDelete(this.beanDescriptor.docStoreQueueId(), this.idValue);
                    break;
                }
                docStoreUpdates.queueIndex(this.beanDescriptor.docStoreQueueId(), this.idValue);
                break;
            }
        }
    }

    private boolean determineUpdateAllLoadedProperties() {
        Boolean txnUpdateAll = this.transaction.isUpdateAllLoadedProperties();
        this.requestUpdateAllLoadedProps = txnUpdateAll != null ? txnUpdateAll : this.isBatchThisRequest() && this.server.isUpdateAllPropertiesInBatch();
        return this.requestUpdateAllLoadedProps;
    }

    public int flags() {
        return this.flags;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public String updatePlanHash() {
        StringBuilder key = this.determineUpdateAllLoadedProperties() ? this.intercept.loadedPropertyKey() : this.intercept.dirtyPropertyKey();
        BeanProperty versionProperty = this.beanDescriptor.versionProperty();
        if (versionProperty != null && this.intercept.isLoadedProperty(versionProperty.propertyIndex())) {
            key.append('v');
        }
        if (this.publish) {
            key.append('p');
        }
        return key.toString();
    }

    public String updateTable() {
        return this.publish ? this.beanDescriptor.baseTable() : this.beanDescriptor.draftTable();
    }

    public DeleteMode deleteMode() {
        return PersistRequest.Type.DELETE_SOFT == this.type ? DeleteMode.SOFT : DeleteMode.HARD;
    }

    private void setVersionValue(Object versionValue) {
        this.version = this.beanDescriptor.setVersion(this.entityBean, versionValue);
    }

    public long version() {
        return this.version;
    }

    private void setTenantId() {
        Object tenantId = this.transaction.getTenantId();
        if (tenantId != null) {
            this.beanDescriptor.setTenantId(this.entityBean, tenantId);
        }
    }

    private void executeInsert() {
        this.setGeneratedId();
        this.setTenantId();
        if (this.controller == null || this.controller.preInsert((BeanPersistRequest)this)) {
            this.beanManager.getBeanPersister().insert(this);
        }
    }

    private void executeUpdate() {
        this.setTenantId();
        if (this.controller == null || this.controller.preUpdate((BeanPersistRequest)this)) {
            this.beanDescriptor.checkAllMutableProperties(this.intercept);
            if (this.beanPersistListener != null) {
                this.updatedProperties = this.updatedProperties();
            }
            this.postControllerPrepareUpdate();
            this.beanManager.getBeanPersister().update(this);
        }
    }

    private void executeSoftDelete() {
        this.setTenantId();
        if (this.controller == null || this.controller.preSoftDelete((BeanPersistRequest)this)) {
            this.postControllerPrepareUpdate();
            this.beanManager.getBeanPersister().update(this);
        }
    }

    private int executeDelete() {
        this.setTenantId();
        if (this.controller == null || this.controller.preDelete((BeanPersistRequest)this)) {
            return this.beanManager.getBeanPersister().delete(this);
        }
        return 0;
    }

    public void docStorePersist() {
        this.idValue = this.beanDescriptor.getId(this.entityBean);
        if (this.type == PersistRequest.Type.UPDATE) {
            this.dirtyProperties = this.intercept.dirtyProperties();
        }
        this.docStoreMode = DocStoreMode.IGNORE;
        try {
            this.docStoreUpdate(this.transaction.getDocStoreTransaction().obtain());
            this.postExecute();
            if (this.type == PersistRequest.Type.UPDATE && this.beanDescriptor.isDocStoreEmbeddedInvalidation() && this.transaction.isPersistCascade()) {
                this.beanDescriptor.docStoreUpdateEmbedded(this, this.transaction.getDocStoreTransaction().queue());
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Error persisting doc store bean", (Throwable)e);
        }
    }

    public long now() {
        if (this.now == 0L) {
            this.now = this.server.clockNow();
        }
        return this.now;
    }

    public boolean isStatelessUpdate() {
        return this.statelessUpdate;
    }

    @Override
    public void profile() {
        this.profileBase(this.type.profileEventId, this.profileOffset, this.beanDescriptor.name(), 1);
    }

    public void flagInsert() {
        this.initGeneratedProperties();
        this.flags = this.intercept.isNew() ? Flags.setInsertNormal(this.flags) : Flags.setInsert(this.flags);
    }

    public void flagUpdate() {
        this.initGeneratedProperties();
        this.flags = this.intercept.isLoaded() ? Flags.setUpdateNormal(this.flags) : Flags.setUpdate(this.flags);
    }

    public boolean isInsertedParent() {
        return Flags.isInsert(this.flags);
    }

    public void addCollectionChange(String name, Object value) {
        if (this.collectionChanges == null) {
            this.collectionChanges = new LinkedHashMap<String, Object>();
        }
        this.collectionChanges.put(name, value);
    }

    public void addBeanUpdate(CacheChangeSet changeSet) {
        if (!this.updatedManysOnly || this.collectionChanges != null) {
            boolean updateNaturalKey = false;
            String key = this.beanDescriptor.cacheKey(this.idValue);
            LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
            EntityBean bean = this.entityBean();
            boolean[] dirtyProperties = this.dirtyProperties();
            if (dirtyProperties != null) {
                for (int i = 0; i < dirtyProperties.length; ++i) {
                    BeanProperty property;
                    if (!dirtyProperties[i] || !(property = this.beanDescriptor.propertyByIndex(i)).isCacheDataInclude()) continue;
                    Object val = property.getCacheDataValue(bean);
                    changes.put(property.name(), val);
                    if (!property.isNaturalKey()) continue;
                    updateNaturalKey = true;
                    String valStr = val == null ? null : val.toString();
                    changeSet.addNaturalKeyPut(this.beanDescriptor, key, valStr);
                }
            }
            if (this.collectionChanges != null) {
                changes.putAll(this.collectionChanges);
            }
            changeSet.addBeanUpdate(this.beanDescriptor, key, changes, updateNaturalKey, this.version());
        }
    }

    public void setImportedOrphanForRemoval(BeanPropertyAssocOne<?> prop) {
        Object orphan = this.getOrigValue(prop);
        if (orphan instanceof EntityBean) {
            this.orphanBean = (EntityBean)orphan;
        }
    }

    public EntityBean importedOrphanForRemoval() {
        return this.orphanBean;
    }

    public String getSelectLastInsertedId() {
        return this.beanDescriptor.selectLastInsertedId(this.publish);
    }

    public boolean isQueueSaveMany() {
        return !this.postExecute;
    }

    public void addSaveMany(SaveMany saveManyRequest) {
        if (this.saveMany == null) {
            this.saveMany = new ArrayList<SaveMany>();
        }
        this.saveMany.add(saveManyRequest);
    }

    public boolean isForcedUpdate() {
        return Flags.isUpdateForce(this.flags);
    }

    public void setSaveRecurse() {
        this.saveRecurse = true;
    }

    private void setGeneratedId() {
        this.beanDescriptor.setGeneratedId(this.entityBean, this.transaction);
    }
}

