/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.Pairs;
import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.NaturalKeyEntryBasic;
import io.ebeaninternal.api.NaturalKeyEntrySimple;
import io.ebeaninternal.api.NaturalKeyEq;
import io.ebeaninternal.api.NaturalKeySet;
import io.ebeaninternal.server.deploy.BeanNaturalKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class NaturalKeyQueryData<T> {
    private final BeanNaturalKey naturalKey;
    private boolean hasIn;
    private String inProperty0;
    private String inProperty1;
    private List<Pairs.Entry> inPairs;
    private List<Object> inValues;
    private String inProperty;
    private List<NaturalKeyEq> eqList;
    private NaturalKeySet set;
    private int hitCount;

    public NaturalKeyQueryData(BeanNaturalKey naturalKey) {
        this.naturalKey = naturalKey;
    }

    private boolean matchProperty(String propName) {
        return this.naturalKey.matchProperty(propName);
    }

    public List<Pairs.Entry> matchInPairs(String property0, String property1, List<Pairs.Entry> inPairs) {
        if (this.hasIn) {
            return null;
        }
        if (this.matchProperty(property0) && this.matchProperty(property1)) {
            this.hasIn = true;
            this.inProperty0 = property0;
            this.inProperty1 = property1;
            this.inPairs = new ArrayList<Pairs.Entry>(inPairs);
            return this.inPairs;
        }
        return null;
    }

    public boolean matchIn(String propName, List<Object> inValues) {
        if (this.hasIn) {
            return false;
        }
        if (this.matchProperty(propName)) {
            this.hasIn = true;
            this.inProperty = propName;
            this.inValues = inValues;
            return true;
        }
        return false;
    }

    public boolean matchEq(String propName, Object bindValue) {
        if (this.matchProperty(propName)) {
            if (this.eqList == null) {
                this.eqList = new ArrayList<NaturalKeyEq>();
            }
            this.eqList.add(new NaturalKeyEq(propName, bindValue));
            return true;
        }
        return false;
    }

    public NaturalKeySet buildKeys() {
        if (!this.expressionCount() || !this.matchProperties()) {
            return null;
        }
        this.set = new NaturalKeySet();
        if (this.inValues != null) {
            this.addInValues();
        } else if (this.inPairs != null) {
            this.addInPairs();
        } else {
            this.addEqualsKey();
        }
        return this.set;
    }

    private void addInPairs() {
        for (Pairs.Entry entry : this.inPairs) {
            this.set.add(new NaturalKeyEntryBasic(this.naturalKey, this.eqList, this.inProperty0, this.inProperty1, entry));
        }
    }

    private void addInValues() {
        if (this.eqList == null) {
            for (Object inValue : this.inValues) {
                this.set.add(new NaturalKeyEntrySimple(inValue));
            }
        } else {
            for (Object inValue : this.inValues) {
                this.set.add(new NaturalKeyEntryBasic(this.naturalKey, this.eqList, this.inProperty, inValue));
            }
        }
    }

    private void addEqualsKey() {
        if (this.eqList.size() == 1) {
            this.set.add(new NaturalKeyEntrySimple(this.eqList.get((int)0).value));
        } else {
            this.set.add(new NaturalKeyEntryBasic(this.naturalKey, this.eqList));
        }
    }

    private boolean matchProperties() {
        if (this.naturalKey.isSingleProperty() && this.naturalKey.matchSingleProperty(this.inProperty != null ? this.inProperty : this.eqList.get((int)0).property)) {
            return true;
        }
        HashSet<String> exprProps = new HashSet<String>();
        if (this.inProperty != null) {
            exprProps.add(this.inProperty);
        }
        if (this.inProperty0 != null) {
            exprProps.add(this.inProperty0);
        }
        if (this.inProperty1 != null) {
            exprProps.add(this.inProperty1);
        }
        if (this.eqList != null) {
            for (NaturalKeyEq eq : this.eqList) {
                exprProps.add(eq.property);
            }
        }
        return this.naturalKey.matchMultiProperties(exprProps);
    }

    private boolean expressionCount() {
        int defined = this.inValues == null ? 0 : 1;
        defined += this.inPairs == null ? 0 : 2;
        return (defined += this.eqList == null ? 0 : this.eqList.size()) == this.naturalKey.length();
    }

    public boolean allHits() {
        return this.hitCount > 0 && this.hitCount == this.set.size() && (this.inValues == null || this.inValues.isEmpty());
    }

    public List<T> removeHits(BeanCacheResult<T> cacheResult) {
        List<BeanCacheResult.Entry<T>> hits = cacheResult.hits();
        this.hitCount = hits.size();
        ArrayList<T> beans = new ArrayList<T>(this.hitCount);
        for (BeanCacheResult.Entry<T> hit : hits) {
            this.removeKey(this.set.getInValue(hit.getKey()));
            beans.add(hit.getBean());
        }
        return beans;
    }

    private void removeKey(Object inValue) {
        if (this.inValues != null) {
            this.inValues.remove(inValue);
        } else if (this.inPairs != null) {
            this.inPairs.remove(inValue);
        }
    }
}

