/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.CacheMode;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.LoadManyBuffer;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.BindPadding;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import java.util.ArrayList;
import java.util.List;

public final class LoadManyRequest
extends LoadRequest {
    private static final System.Logger log = CoreLog.log;
    private final LoadManyBuffer loadContext;
    private final boolean onlyIds;
    private final boolean loadCache;
    private final BeanCollection<?> originCollection;
    private boolean originIncluded;

    public LoadManyRequest(LoadManyBuffer loadContext, boolean onlyIds, boolean loadCache, BeanCollection<?> originCollection) {
        super(null, true);
        this.loadContext = loadContext;
        this.onlyIds = onlyIds;
        this.loadCache = loadCache;
        this.originCollection = originCollection;
    }

    public LoadManyRequest(LoadManyBuffer loadContext, OrmQueryRequest<?> parentRequest) {
        super(parentRequest, false);
        this.loadContext = loadContext;
        this.onlyIds = false;
        this.loadCache = false;
        this.originCollection = null;
    }

    @Override
    public Class<?> beanType() {
        return this.loadContext.descriptor().type();
    }

    public String description() {
        return this.loadContext.fullPath();
    }

    private List<Object> parentIdList(SpiEbeanServer server) {
        ArrayList<Object> idList = new ArrayList<Object>();
        BeanPropertyAssocMany<?> many = this.many();
        for (int i = 0; i < this.loadContext.size(); ++i) {
            BeanCollection<?> bc = this.loadContext.get(i);
            if (bc == null) continue;
            if (this.lazy && !this.originIncluded && bc == this.originCollection) {
                this.originIncluded = true;
            }
            idList.add(many.parentId(bc.owner()));
            bc.setLoader((BeanCollectionLoader)server);
        }
        if (this.originCollection != null && !this.originIncluded) {
            CoreLog.log.log(System.Logger.Level.INFO, "Batch lazy loading including origin collection - size:{0}", idList.size());
            idList.add(many.parentId(this.originCollection.owner()));
            this.originCollection.setLoader((BeanCollectionLoader)server);
        }
        if (many.targetDescriptor().isPadInExpression()) {
            BindPadding.padIds(idList);
        }
        return idList;
    }

    private BeanPropertyAssocMany<?> many() {
        return this.loadContext.beanProperty();
    }

    public SpiQuery<?> createQuery(SpiEbeanServer server) {
        String extraWhere;
        BeanPropertyAssocMany many = this.many();
        SpiQuery query = many.newQuery(server);
        String orderBy = many.lazyFetchOrderBy();
        if (orderBy != null) {
            query.order(orderBy);
        }
        if ((extraWhere = many.extraWhere()) != null) {
            query.where().raw(extraWhere.replace("${ta}", "t0").replace("${mta}", "int_"));
        }
        query.setLazyLoadForParents(many);
        many.addWhereParentIdIn(query, this.parentIdList(server), this.loadContext.isUseDocStore());
        query.setPersistenceContext(this.loadContext.persistenceContext());
        query.setLoadDescription(this.lazy ? "+lazy" : "+query", this.description());
        if (this.lazy) {
            query.setLazyLoadBatchSize(this.loadContext.batchSize());
        } else {
            query.setBeanCacheMode(CacheMode.OFF);
        }
        this.loadContext.configureQuery(query);
        if (this.onlyIds) {
            query.select(many.targetIdProperty());
        }
        return query;
    }

    public void postLoad() {
        BeanDescriptor<?> desc = this.loadContext.descriptor();
        BeanPropertyAssocMany<?> many = this.many();
        for (int i = 0; i < this.loadContext.size(); ++i) {
            BeanCollection<?> bc = this.loadContext.get(i);
            if (bc == null) continue;
            if (bc.checkEmptyLazyLoad()) {
                if (!log.isLoggable(System.Logger.Level.DEBUG)) continue;
                EntityBean ownerBean = bc.owner();
                Object parentId = desc.getId(ownerBean);
                log.log(System.Logger.Level.DEBUG, "BeanCollection after lazy load was empty. type:{0} id:{1} owner:{2}", ownerBean.getClass().getName(), parentId, ownerBean);
                continue;
            }
            if (!this.loadCache || !many.isUseCache()) continue;
            desc.cacheManyPropPut(many, bc, desc.cacheKeyForBean(bc.owner()));
        }
    }
}

