/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class CoreListValue
implements Configuration.ListValue {
    private final CoreConfiguration config;

    public CoreListValue(CoreConfiguration config) {
        this.config = config;
    }

    @Override
    public List<String> of(String key) {
        String val = this.config.value(key);
        if (val == null) {
            return Collections.emptyList();
        }
        return this.split(val);
    }

    @Override
    public List<String> of(String key, String ... defaultValues) {
        String val = this.config.value(key);
        if (val == null) {
            return Arrays.asList(defaultValues);
        }
        return this.split(val);
    }

    @Override
    public List<Integer> ofInt(String key) {
        String val = this.config.value(key);
        if (val == null) {
            return Collections.emptyList();
        }
        return this.splitInt(val);
    }

    @Override
    public List<Integer> ofInt(String key, int ... defaultValues) {
        String val = this.config.value(key);
        if (val == null) {
            ArrayList<Integer> ints = new ArrayList<Integer>(defaultValues.length);
            for (int defaultVal : defaultValues) {
                ints.add(defaultVal);
            }
            return ints;
        }
        return this.splitInt(val);
    }

    @Override
    public List<Long> ofLong(String key) {
        String val = this.config.value(key);
        if (val == null) {
            return Collections.emptyList();
        }
        return this.splitLong(val);
    }

    @Override
    public List<Long> ofLong(String key, long ... defaultValues) {
        String val = this.config.value(key);
        if (val == null) {
            ArrayList<Long> ints = new ArrayList<Long>(defaultValues.length);
            for (long defaultVal : defaultValues) {
                ints.add(defaultVal);
            }
            return ints;
        }
        return this.splitLong(val);
    }

    List<String> split(String allValues) {
        return Arrays.asList(allValues.split(","));
    }

    List<Integer> splitInt(String allValues) {
        List<String> values = this.split(allValues);
        ArrayList<Integer> ints = new ArrayList<Integer>(values.size());
        for (String val : values) {
            ints.add(Integer.parseInt(val.trim()));
        }
        return ints;
    }

    List<Long> splitLong(String allValues) {
        List<String> values = this.split(allValues);
        ArrayList<Long> longs = new ArrayList<Long>(values.size());
        for (String val : values) {
            longs.add(Long.parseLong(val.trim()));
        }
        return longs;
    }
}

