/*
 * Decompiled with CFR 0.152.
 */
package in.uncod.android.bypass;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.Patterns;
import android.util.TypedValue;
import in.uncod.android.bypass.Document;
import in.uncod.android.bypass.Element;
import in.uncod.android.bypass.ReverseSpannableStringBuilder;
import in.uncod.android.bypass.style.HorizontalLineSpan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Bypass {
    private final Options mOptions;
    private final int mListItemIndent;
    private final int mBlockQuoteIndent;
    private final int mCodeBlockIndent;
    private final int mHruleSize;
    private final int mHruleTopBottomPadding;
    private final Map<Element, Integer> mOrderedListNumber = new ConcurrentHashMap<Element, Integer>();

    @Deprecated
    public Bypass() {
        this.mOptions = new Options();
        this.mListItemIndent = 20;
        this.mBlockQuoteIndent = 10;
        this.mCodeBlockIndent = 10;
        this.mHruleSize = 2;
        this.mHruleTopBottomPadding = 20;
    }

    public Bypass(Context context) {
        this(context, new Options());
    }

    public Bypass(Context context, Options options) {
        this.mOptions = options;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        this.mListItemIndent = (int)TypedValue.applyDimension((int)this.mOptions.mListItemIndentUnit, (float)this.mOptions.mListItemIndentSize, (DisplayMetrics)dm);
        this.mBlockQuoteIndent = (int)TypedValue.applyDimension((int)this.mOptions.mBlockQuoteIndentUnit, (float)this.mOptions.mBlockQuoteIndentSize, (DisplayMetrics)dm);
        this.mCodeBlockIndent = (int)TypedValue.applyDimension((int)this.mOptions.mCodeBlockIndentUnit, (float)this.mOptions.mCodeBlockIndentSize, (DisplayMetrics)dm);
        this.mHruleSize = (int)TypedValue.applyDimension((int)this.mOptions.mHruleUnit, (float)this.mOptions.mHruleSize, (DisplayMetrics)dm);
        this.mHruleTopBottomPadding = (int)dm.density * 10;
    }

    public CharSequence markdownToSpannable(String markdown) {
        return this.markdownToSpannable(markdown, null);
    }

    public CharSequence markdownToSpannable(String markdown, ImageGetter imageGetter) {
        Document document = this.processMarkdown(markdown);
        CharSequence[] spans = new CharSequence[document.getElementCount()];
        for (int i = 0; i < document.getElementCount(); ++i) {
            spans[i] = this.recurseElement(document.getElement(i), imageGetter);
        }
        return TextUtils.concat((CharSequence[])spans);
    }

    private native Document processMarkdown(String var1);

    private CharSequence recurseElement(Element element, ImageGetter imageGetter) {
        Element.Type type = element.getType();
        boolean isOrderedList = false;
        if (type == Element.Type.LIST) {
            String flagsStr = element.getAttribute("flags");
            try {
                int flags = Integer.parseInt(flagsStr);
                isOrderedList = (flags & 1) != 0;
            }
            catch (Exception e) {
                isOrderedList = true;
            }
            if (isOrderedList) {
                this.mOrderedListNumber.put(element, 1);
            }
        }
        CharSequence[] spans = new CharSequence[element.size()];
        for (int i = 0; i < element.size(); ++i) {
            spans[i] = this.recurseElement(element.children[i], imageGetter);
        }
        if (isOrderedList) {
            this.mOrderedListNumber.remove(this);
        }
        CharSequence concat = TextUtils.concat((CharSequence[])spans);
        ReverseSpannableStringBuilder builder = new ReverseSpannableStringBuilder();
        String text = element.getText();
        if (element.size() == 0 && element.getParent() != null && element.getParent().getType() != Element.Type.BLOCK_CODE) {
            text = text.replace('\n', ' ');
        }
        Drawable imageDrawable = null;
        if (type == Element.Type.IMAGE && imageGetter != null && !TextUtils.isEmpty((CharSequence)element.getAttribute("link"))) {
            imageDrawable = imageGetter.getDrawable(element.getAttribute("link"));
        }
        switch (type) {
            case LIST: {
                if (element.getParent() == null || element.getParent().getType() != Element.Type.LIST_ITEM) break;
                builder.append("\n");
                break;
            }
            case LINEBREAK: {
                builder.append("\n");
                break;
            }
            case LIST_ITEM: {
                builder.append(" ");
                if (this.mOrderedListNumber.containsKey(element.getParent())) {
                    int number = this.mOrderedListNumber.get(element.getParent());
                    builder.append(Integer.toString(number) + ".");
                    this.mOrderedListNumber.put(element.getParent(), number + 1);
                } else {
                    builder.append(this.mOptions.mUnorderedListItem);
                }
                builder.append("  ");
                break;
            }
            case AUTOLINK: {
                builder.append(element.getAttribute("link"));
                break;
            }
            case HRULE: {
                builder.append("-");
                break;
            }
            case IMAGE: {
                if (imageDrawable == null) {
                    String show = element.getAttribute("alt");
                    if (TextUtils.isEmpty((CharSequence)show)) {
                        show = element.getAttribute("title");
                    }
                    if (TextUtils.isEmpty((CharSequence)show)) break;
                    show = "[" + show + "]";
                    builder.append(show);
                    break;
                }
                builder.append("\ufffc");
            }
        }
        builder.append(text);
        builder.append(concat);
        if (type == Element.Type.LIST_ITEM) {
            if (element.size() == 0 || !element.children[element.size() - 1].isBlockElement()) {
                builder.append("\n");
            }
        } else if (element.isBlockElement() && type != Element.Type.BLOCK_QUOTE) {
            if (type == Element.Type.LIST) {
                if (element.getParent() == null || element.getParent().getType() != Element.Type.LIST_ITEM) {
                    builder.append("\n");
                }
            } else if (element.getParent() != null && element.getParent().getType() == Element.Type.LIST_ITEM) {
                builder.append("\n");
            } else {
                builder.append("\n\n");
            }
        }
        switch (type) {
            case HEADER: {
                String levelStr = element.getAttribute("level");
                int level = Integer.parseInt(levelStr);
                Bypass.setSpan(builder, new RelativeSizeSpan(this.mOptions.mHeaderSizes[level - 1]));
                Bypass.setSpan(builder, new StyleSpan(1));
                break;
            }
            case LIST: {
                Bypass.setBlockSpan(builder, new LeadingMarginSpan.Standard(this.mListItemIndent));
                break;
            }
            case EMPHASIS: {
                Bypass.setSpan(builder, new StyleSpan(2));
                break;
            }
            case DOUBLE_EMPHASIS: {
                Bypass.setSpan(builder, new StyleSpan(1));
                break;
            }
            case TRIPLE_EMPHASIS: {
                Bypass.setSpan(builder, new StyleSpan(3));
                break;
            }
            case BLOCK_CODE: {
                Bypass.setSpan(builder, new LeadingMarginSpan.Standard(this.mCodeBlockIndent));
                Bypass.setSpan(builder, new TypefaceSpan("monospace"));
                break;
            }
            case CODE_SPAN: {
                Bypass.setSpan(builder, new TypefaceSpan("monospace"));
                break;
            }
            case AUTOLINK: 
            case LINK: {
                String link = element.getAttribute("link");
                if (Patterns.EMAIL_ADDRESS.matcher(link).matches()) {
                    link = "mailto:" + link;
                }
                Bypass.setSpan(builder, new URLSpan(link));
                break;
            }
            case BLOCK_QUOTE: {
                Bypass.setBlockSpan(builder, new LeadingMarginSpan.Standard(this.mBlockQuoteIndent));
                Bypass.setBlockSpan(builder, new QuoteSpan(this.mOptions.mBlockQuoteColor));
                Bypass.setBlockSpan(builder, new LeadingMarginSpan.Standard(this.mBlockQuoteIndent));
                Bypass.setBlockSpan(builder, new StyleSpan(2));
                break;
            }
            case STRIKETHROUGH: {
                Bypass.setSpan(builder, new StrikethroughSpan());
                break;
            }
            case HRULE: {
                Bypass.setSpan(builder, (Object)new HorizontalLineSpan(this.mOptions.mHruleColor, this.mHruleSize, this.mHruleTopBottomPadding));
                break;
            }
            case IMAGE: {
                if (imageDrawable == null) break;
                Bypass.setSpan(builder, new ImageSpan(imageDrawable));
            }
        }
        return builder;
    }

    private static void setSpan(SpannableStringBuilder builder, Object what) {
        builder.setSpan(what, 0, builder.length(), 33);
    }

    private static void setBlockSpan(SpannableStringBuilder builder, Object what) {
        builder.setSpan(what, 0, builder.length() - 1, 33);
    }

    static {
        System.loadLibrary("bypass");
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1);
    }

    public static final class Options {
        private float[] mHeaderSizes = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
        private String mUnorderedListItem = "\u2022";
        private int mListItemIndentUnit = 1;
        private float mListItemIndentSize = 10.0f;
        private int mBlockQuoteColor = -16776961;
        private int mBlockQuoteIndentUnit = 1;
        private float mBlockQuoteIndentSize = 10.0f;
        private int mCodeBlockIndentUnit = 1;
        private float mCodeBlockIndentSize = 10.0f;
        private int mHruleColor = -7829368;
        private int mHruleUnit = 1;
        private float mHruleSize = 1.0f;

        public Options setHeaderSizes(float[] headerSizes) {
            if (headerSizes == null) {
                throw new IllegalArgumentException("headerSizes must not be null");
            }
            if (headerSizes.length != 6) {
                throw new IllegalArgumentException("headerSizes must have 6 elements (h1 through h6)");
            }
            this.mHeaderSizes = headerSizes;
            return this;
        }

        public Options setUnorderedListItem(String unorderedListItem) {
            this.mUnorderedListItem = unorderedListItem;
            return this;
        }

        public Options setListItemIndentSize(int unit, float size) {
            this.mListItemIndentUnit = unit;
            this.mListItemIndentSize = size;
            return this;
        }

        public Options setBlockQuoteColor(int color) {
            this.mBlockQuoteColor = color;
            return this;
        }

        public Options setBlockQuoteIndentSize(int unit, float size) {
            this.mBlockQuoteIndentUnit = unit;
            this.mBlockQuoteIndentSize = size;
            return this;
        }

        public Options setCodeBlockIndentSize(int unit, float size) {
            this.mCodeBlockIndentUnit = unit;
            this.mCodeBlockIndentSize = size;
            return this;
        }

        public Options setHruleColor(int color) {
            this.mHruleColor = color;
            return this;
        }

        public Options setHruleSize(int unit, float size) {
            this.mHruleUnit = unit;
            this.mHruleSize = size;
            return this;
        }
    }
}

