/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.markdown.ui;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;

public class AutoGridView
extends GridView {
    private boolean hasCalculated = false;
    private List<Integer> _rows = new ArrayList<Integer>();
    private int mPaddingBottom = 0;
    private int mPaddingTop = 0;
    private int numColumnsID;
    private int previousFirstVisible;
    private int numColumns = 1;

    public AutoGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public AutoGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public AutoGridView(Context context) {
        super(context);
    }

    private void setHeightAtRow(int index, int height) {
        while (this._rows.size() <= index) {
            this._rows.add(0);
        }
        int h = this._rows.get(index);
        h = height;
        this._rows.set(index, h);
    }

    private int getOverAllHeight() {
        int height = this.mPaddingTop;
        if (this._rows != null && this._rows.size() > 0) {
            height += (this._rows.size() - 1) * height;
            for (Integer integer : this._rows) {
                height += integer.intValue();
            }
        }
        return height += this.mPaddingBottom;
    }

    private void init(AttributeSet attrs) {
        int count = attrs.getAttributeCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String name = attrs.getAttributeName(i);
                if (name == null || !name.equals("numColumns")) continue;
                this.numColumnsID = attrs.getAttributeResourceValue(i, 1);
                this.updateColumns();
                break;
            }
        }
    }

    private void updateColumns() {
        this.numColumns = this.getContext().getResources().getInteger(this.numColumnsID);
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        super.setNumColumns(numColumns);
        this.setSelection(this.previousFirstVisible);
    }

    protected void onLayout(boolean changed, int leftPos, int topPos, int rightPos, int bottomPos) {
        super.onLayout(changed, leftPos, topPos, rightPos, bottomPos);
        this.setHeights();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.updateColumns();
        this.setNumColumns(this.numColumns);
    }

    protected void onScrollChanged(int newHorizontal, int newVertical, int oldHorizontal, int oldVertical) {
        int firstVisible = this.getFirstVisiblePosition();
        if (this.previousFirstVisible != firstVisible) {
            this.previousFirstVisible = firstVisible;
            this.setHeights();
        }
        super.onScrollChanged(newHorizontal, newVertical, oldHorizontal, oldVertical);
    }

    private boolean setHeights() {
        boolean calculated = this.hasCalculated;
        ListAdapter adapter = this.getAdapter();
        if (adapter != null) {
            int row = 0;
            for (int i = 0; i < this.getChildCount(); i += this.numColumns) {
                View view;
                int j;
                int maxHeight = 0;
                for (j = i; j < i + this.numColumns; ++j) {
                    view = this.getChildAt(j);
                    if (view == null || view.getHeight() <= maxHeight) continue;
                    maxHeight = view.getHeight();
                }
                if (maxHeight > 0) {
                    this.setHeightAtRow(row, maxHeight);
                    for (j = i; j < i + this.numColumns; ++j) {
                        view = this.getChildAt(j);
                        if (view == null || view.getHeight() == maxHeight) continue;
                        view.setMinimumHeight(maxHeight);
                    }
                }
                ++row;
                this.hasCalculated = true;
            }
        }
        if (!calculated) {
            return this.hasCalculated;
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setHeights();
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, heightSpec);
        if (this.hasCalculated) {
            Log.d((String)"Markdown", (String)("has calculated " + this.getOverAllHeight()));
            this.setMeasuredDimension(this.getMeasuredWidth(), this.getOverAllHeight());
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingTop = top;
        this.mPaddingBottom = bottom;
        super.setPadding(left, top, right, bottom);
    }
}

