/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.markdown;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import eu.codlab.markdown.Markdown;
import eu.codlab.markdown.R;
import eu.codlab.markdown.entities.ArrayEntity;
import eu.codlab.markdown.entities.ColorEntity;
import eu.codlab.markdown.entities.ImageEntity;
import eu.codlab.markdown.entities.MarkDownEntity;
import eu.codlab.markdown.entities.TextEntity;
import eu.codlab.markdown.ui.AutoGridView;
import eu.codlab.markdown.ui.AutoMeasureAdapter;
import java.util.List;

public class MarkdownView
extends LinearLayout {
    private int _md_array_spacing;
    private int _md_array_header_color;
    private int _md_array_body_color;
    private int _md_text_color;
    private int _md_cell_padding;
    private int _md_padding_left;
    private int _md_padding_right;
    private int _last_color;
    private int _last_background_color;
    private Markdown _markdown_item;
    private List<MarkDownEntity> _entities;
    private ViewGroup _layout;

    private void init(AttributeSet attributes) {
        this._markdown_item = new Markdown(this.getContext());
        View main = ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(R.layout.markdown_view, (ViewGroup)this, false);
        this._layout = (ViewGroup)main.findViewById(R.id.markdown_area);
        this.addView(main);
        if (attributes != null) {
            TypedArray theAttrs = this.getContext().obtainStyledAttributes(attributes, R.styleable.MarkdownView);
            this._md_array_body_color = theAttrs.getColor(R.styleable.MarkdownView_md_array_body_color, -1);
            this._md_array_header_color = theAttrs.getColor(R.styleable.MarkdownView_md_array_header_color, -3355444);
            this._md_text_color = theAttrs.getColor(R.styleable.MarkdownView_md_text_color, -16777216);
            this._md_array_spacing = (int)theAttrs.getDimension(R.styleable.MarkdownView_md_array_spacing, 1.0f);
            this._md_cell_padding = (int)theAttrs.getDimension(R.styleable.MarkdownView_md_cell_padding, 5.0f);
            this._md_padding_left = (int)theAttrs.getDimension(R.styleable.MarkdownView_md_padding_left, 0.0f);
            this._md_padding_right = (int)theAttrs.getDimension(R.styleable.MarkdownView_md_padding_right, 0.0f);
            this._last_color = this._md_text_color;
            this._last_background_color = 0;
            theAttrs.recycle();
        } else {
            this._md_array_body_color = -1;
            this._md_array_header_color = -3355444;
            this._md_text_color = -16777216;
            this._md_array_spacing = 1;
            this._md_cell_padding = 5;
            this._md_padding_right = 0;
            this._md_padding_left = 0;
            this._last_color = -16777216;
            this._last_background_color = 0;
        }
    }

    public MarkdownView(Context context) {
        super(context);
        this.init(null);
    }

    public MarkdownView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MarkdownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void clear() {
    }

    public void setStringContent(String text) {
        this.clear();
        List<MarkDownEntity> entities = this._markdown_item.processText(text);
        this.setContent(entities);
    }

    public void setAssetContent(String asset) {
        this.clear();
        List<MarkDownEntity> entities = this._markdown_item.processAssetFile(asset);
        this.setContent(entities);
    }

    private void setContent(List<MarkDownEntity> entities) {
        this._entities = entities;
        if (this._entities != null) {
            boolean last_required_new_line = false;
            for (MarkDownEntity entity : this._entities) {
                if (last_required_new_line) {
                    this.addTextEntityInLayout(new TextEntity(" "));
                    last_required_new_line = false;
                }
                if (entity instanceof ImageEntity) {
                    this.addImageEntityInLayout((ImageEntity)entity);
                    last_required_new_line = true;
                    continue;
                }
                if (entity instanceof TextEntity) {
                    this.addTextEntityInLayout((TextEntity)entity);
                    last_required_new_line = false;
                    continue;
                }
                if (entity instanceof ColorEntity) {
                    this.addColorEntity((ColorEntity)entity);
                    if (!((ColorEntity)entity).isDefaultColor()) continue;
                    last_required_new_line = true;
                    continue;
                }
                if (!(entity instanceof ArrayEntity)) continue;
                this.addArrayEntityInLayout((ArrayEntity)entity);
                last_required_new_line = true;
            }
        }
    }

    private void addColorEntity(ColorEntity entity) {
        if (!entity.isDefaultColor()) {
            this._last_color = entity.getColorInteger();
            this._last_background_color = entity.getBackgroundColorInteger();
        } else {
            this._last_color = this._md_text_color;
            this._last_background_color = 0;
        }
    }

    private void addTextEntityInLayout(TextEntity entity) {
        TextView view = new TextView(this.getContext());
        if (this._last_background_color != 0) {
            view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        } else {
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        }
        view.setTextColor(this._last_color);
        view.setBackgroundColor(this._last_background_color);
        view.setPadding(this._md_padding_left, 0, this._md_padding_right, 0);
        view.setText(entity.getString());
        view.setClickable(true);
        view.setLinksClickable(true);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        this._layout.addView((View)view);
    }

    private void addArrayEntityInLayout(ArrayEntity entity) {
        AutoGridView gridview = new AutoGridView(this.getContext());
        gridview.setNumColumns(entity.getNumberColumns());
        gridview.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, 0x3FFFFFFF));
        gridview.setBackgroundColor(-16777216);
        gridview.setColumnWidth(-1);
        gridview.setVerticalSpacing(this._md_array_spacing);
        gridview.setHorizontalSpacing(this._md_array_spacing);
        gridview.setPadding(this._md_array_spacing, this._md_array_spacing, this._md_array_spacing, this._md_array_spacing);
        gridview.setStretchMode(2);
        AutoMeasureAdapter adapter = entity.createAdapter(this.getContext(), this._last_color, this._md_array_header_color, this._md_array_body_color, this._md_cell_padding);
        gridview.setAdapter((ListAdapter)adapter);
        this._layout.addView((View)gridview);
    }

    private void addImageEntityInLayout(ImageEntity entity) {
        ImageView view = new ImageView(this.getContext());
        view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        try {
            this._layout.addView((View)view);
            if (entity.isHttp()) {
                Picasso.with((Context)this.getContext()).load(entity.getSrc()).into(view);
            } else {
                int resID = this.getResources().getIdentifier(entity.getSrc(), "drawable", this.getContext().getPackageName());
                view.setImageResource(resID);
            }
            try {
                if (null != entity.getAlt() && entity.getAlt().startsWith("http")) {
                    final Uri uri = Uri.parse((String)entity.getAlt());
                    view.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Intent i = new Intent("android.intent.action.VIEW");
                            i.setData(uri);
                            v.getContext().startActivity(i);
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

