/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.util.asm;

import dev.velix.imperat.util.asm.MethodCaller;
import dev.velix.imperat.util.asm.MethodCallerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MethodHandlesCallerFactory
implements MethodCallerFactory {
    public static final MethodHandlesCallerFactory INSTANCE = new MethodHandlesCallerFactory();

    MethodHandlesCallerFactory() {
    }

    @Override
    @NotNull
    public MethodCaller createFor(@NotNull Method method) throws Throwable {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        final MethodHandle handle = MethodHandles.lookup().unreflect(method);
        final String methodString = method.toString();
        final boolean isStatic = Modifier.isStatic(method.getModifiers());
        return new MethodCaller(){

            @Override
            public Object call(@Nullable Object instance, Object ... arguments) {
                if (!isStatic) {
                    ArrayList<Object> args = new ArrayList<Object>();
                    args.add(instance);
                    Collections.addAll(args, arguments);
                    try {
                        return handle.invokeWithArguments(args);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                try {
                    return handle.invokeWithArguments(arguments);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return "MethodHandlesCaller(" + methodString + ")";
            }
        };
    }

    public String toString() {
        return "MethodHandlesCallerFactory";
    }
}

