/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.resolvers;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.SuggestionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public interface SuggestionResolver<S extends Source> {
    public static <S extends Source> SuggestionResolver<S> plain(List<String> results) {
        return (context, parameterToComplete) -> results;
    }

    public static <S extends Source> SuggestionResolver<S> plain(String ... results) {
        return SuggestionResolver.plain(Arrays.asList(results));
    }

    public static <S extends Source> SuggestionResolver<S> forCommand(Command<S> command) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(command.name());
        list.addAll(command.aliases());
        return SuggestionResolver.plain(list);
    }

    public List<String> autoComplete(SuggestionContext<S> var1, CommandParameter<S> var2);

    default public CompletableFuture<List<String>> asyncAutoComplete(SuggestionContext<S> context, CommandParameter<S> parameter) {
        return CompletableFuture.supplyAsync(() -> this.autoComplete(context, parameter));
    }
}

