/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.resolvers;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.Source;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="1.0.0")
public interface PermissionResolver<S extends Source> {
    public boolean hasPermission(@NotNull S var1, @Nullable String var2);

    default public boolean hasUsagePermission(S source, @Nullable CommandUsage<S> usage) {
        if (usage == null || usage.permission() == null) {
            return true;
        }
        if (!this.hasPermission(source, usage.permission())) {
            return false;
        }
        for (CommandParameter<S> parameter : usage.getParameters()) {
            if (parameter.permission() == null || this.hasPermission(source, parameter.permission())) continue;
            return false;
        }
        return true;
    }
}

