/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.placeholders;

import dev.velix.imperat.ImperatConfig;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.placeholders.PlaceholderImpl;
import dev.velix.imperat.placeholders.PlaceholderResolver;
import dev.velix.imperat.util.Preconditions;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Placeholder<S extends Source> {
    @NotNull
    public String id();

    @NotNull
    public PlaceholderResolver<S> resolver();

    public boolean isUsedIn(String var1);

    default public String resolveInput(String id, ImperatConfig<S> imperat) {
        return this.resolver().resolve(id, imperat);
    }

    public String replaceResolved(ImperatConfig<S> var1, String var2, String var3);

    public static <S extends Source> Builder<S> builder(String id) {
        return new Builder(id);
    }

    public static final class Builder<S extends Source> {
        private final String id;
        private PlaceholderResolver<S> resolver = null;

        Builder(String id) {
            this.id = id;
        }

        public Builder<S> resolver(PlaceholderResolver<S> resolver) {
            this.resolver = resolver;
            return this;
        }

        public Placeholder<S> build() {
            Preconditions.notNull(this.resolver, "resolver is not set in the placeholder-builder");
            return new PlaceholderImpl<S>(this.id, this.resolver);
        }
    }
}

