/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.help;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.help.HelpHyphen;
import dev.velix.imperat.help.HelpTemplate;
import dev.velix.imperat.help.HyphenContent;
import dev.velix.imperat.help.UsageDisplayer;
import dev.velix.imperat.help.UsageFormatter;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

final class HelpTemplateImpl<S extends Source>
extends HelpTemplate<S> {
    private final HelpHyphen<S> headerProvider;
    private final HelpHyphen<S> footerProvider;
    @Nullable
    private final UsageDisplayer<S> displayerFunc;

    HelpTemplateImpl(UsageFormatter formatter, HelpHyphen<S> headerProvider, HelpHyphen<S> footerProvider, @Nullable UsageDisplayer<S> displayerFunc) {
        super(formatter);
        this.headerProvider = headerProvider;
        this.footerProvider = footerProvider;
        this.displayerFunc = displayerFunc;
    }

    @Override
    public String getHeader(Command<S> command, int currentPage, int maxPages) {
        return this.headerProvider.value(HyphenContent.of(command, currentPage, maxPages));
    }

    @Override
    public String getFooter(Command<S> command, int currentPage, int maxPages) {
        return this.footerProvider.value(HyphenContent.of(command, currentPage, maxPages));
    }

    @Override
    public void displayHeaderHyphen(Command<S> command, Source source, int page, int maxPages) {
        source.reply(this.getHeader(command, 1, 1));
    }

    @Override
    public void displayFooterHyphen(Command<S> command, Source source, int page, int maxPages) {
        source.reply(this.getFooter(command, 1, 1));
    }

    @Override
    public void display(ExecutionContext<S> context, S source, UsageFormatter formatter, Collection<? extends CommandUsage<S>> commandUsages) throws ImperatException {
        if (this.displayerFunc == null) {
            super.display(context, source, formatter, commandUsages);
        } else {
            this.displayerFunc.accept(context, (Source)source, (Collection<CommandUsage<S>>)commandUsages);
        }
    }
}

