/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context.internal;

import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.context.internal.ShiftOperation;
import dev.velix.imperat.context.internal.ShiftTarget;
import java.util.function.IntUnaryOperator;

public final class Cursor<S extends Source> {
    CommandInputStream<S> stream;
    int parameter;
    int raw;

    Cursor(CommandInputStream<S> stream, int parameter, int raw) {
        this.stream = stream;
        this.parameter = parameter;
        this.raw = raw;
    }

    void shift(ShiftTarget shift, IntUnaryOperator operator) {
        switch (shift) {
            case RAW_ONLY: {
                this.raw = operator.applyAsInt(this.raw);
                break;
            }
            case PARAMETER_ONLY: {
                this.parameter = operator.applyAsInt(this.parameter);
                break;
            }
            default: {
                this.raw = operator.applyAsInt(this.raw);
                this.parameter = operator.applyAsInt(this.parameter);
            }
        }
    }

    void shift(ShiftTarget target, ShiftOperation operation) {
        this.shift(target, operation.operator);
    }

    boolean canContinue(ShiftTarget target) {
        return target.canContinue(this);
    }

    boolean isLast(ShiftTarget shiftTarget, int maxParams, int maxRaws) {
        if (shiftTarget == ShiftTarget.PARAMETER_ONLY) {
            return this.parameter == maxParams - 1;
        }
        if (shiftTarget == ShiftTarget.RAW_ONLY) {
            return this.raw == maxRaws - 1;
        }
        return this.parameter == maxParams - 1 && this.raw == maxRaws - 1;
    }

    boolean isLast(ShiftTarget shiftTarget) {
        return this.isLast(shiftTarget, this.stream.parametersLength(), this.stream.rawsLength());
    }

    int maxRaws() {
        return this.stream.rawsLength();
    }

    int maxParameters() {
        return this.stream.parametersLength();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cursor)) {
            return false;
        }
        Cursor other = (Cursor)o;
        if (this.parameter != other.parameter) {
            return false;
        }
        return this.raw == other.raw;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.parameter;
        result = result * 59 + this.raw;
        return result;
    }
}

