/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context.internal;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.ArgumentQueue;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.Cursor;
import dev.velix.imperat.context.internal.ShiftOperation;
import dev.velix.imperat.context.internal.ShiftTarget;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public interface CommandInputStream<S extends Source> {
    @NotNull
    public Cursor<S> cursor();

    @NotNull
    public Optional<CommandParameter<S>> currentParameter();

    public Optional<CommandParameter<S>> peekParameter();

    public Optional<CommandParameter<S>> popParameter();

    @NotNull
    public Optional<Character> currentLetter();

    public Optional<Character> peekLetter();

    public Optional<Character> popLetter();

    @NotNull
    public Optional<String> currentRaw();

    public Optional<String> peekRaw();

    public Optional<String> popRaw();

    public boolean hasNextLetter();

    public boolean hasNextRaw();

    public boolean hasNextParameter();

    @NotNull
    public ArgumentQueue getRawQueue();

    @NotNull
    public CommandUsage<S> getUsage();

    public boolean skip();

    public boolean skipLetter();

    default public boolean skipRaw() {
        Cursor<S> cursor = this.cursor();
        int prevRaw = cursor.raw;
        cursor.shift(ShiftTarget.RAW_ONLY, ShiftOperation.RIGHT);
        return cursor.raw > prevRaw;
    }

    default public boolean skipParameter() {
        Cursor<S> cursor = this.cursor();
        int prevParam = cursor.parameter;
        cursor.shift(ShiftTarget.PARAMETER_ONLY, ShiftOperation.RIGHT);
        return cursor.parameter > prevParam;
    }

    default public int currentRawPosition() {
        return this.cursor().raw;
    }

    default public int currentParameterPosition() {
        return this.cursor().parameter;
    }

    default public int rawsLength() {
        return this.getRawQueue().size();
    }

    default public int parametersLength() {
        return this.getUsage().size();
    }

    default public boolean skipTill(char target) {
        boolean reached = false;
        while (this.hasNextLetter()) {
            if (this.currentLetter().map(current -> current.charValue() == target).orElse(false).booleanValue()) {
                reached = true;
                break;
            }
            this.popLetter();
        }
        this.skipLetter();
        return reached;
    }

    default public String collectBeforeFirst(char c) {
        Character current;
        StringBuilder builder = new StringBuilder();
        while (this.hasNextLetter() && (current = (Character)this.currentLetter().orElse(null)) != null && current.charValue() != c) {
            builder.append(current);
            this.skipLetter();
        }
        return builder.toString();
    }

    default public String readInput() {
        return this.currentRaw().orElseThrow();
    }
}

