/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context;

import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.Patterns;
import dev.velix.imperat.util.StringUtils;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="1.0.0")
public interface FlagData<S extends Source> {
    public static <S extends Source, T> FlagData<S> create(String name, List<String> alias, ParameterType<S, T> inputType, boolean free) {
        return new FlagDataImpl<S>(name, alias, inputType, free);
    }

    public static <S extends Source, T> FlagData<S> create(String name, List<String> alias, ParameterType<S, T> inputType) {
        return FlagData.create(name, alias, inputType, false);
    }

    public static <S extends Source> FlagData<S> createSwitch(String name, List<String> aliases) {
        return FlagData.create(name, aliases, null);
    }

    @NotNull
    public String name();

    @NotNull
    public List<String> aliases();

    public boolean isFree();

    public <T> ParameterType<S, T> inputType();

    default public boolean hasAlias(String alias) {
        return this.aliases().contains(alias.toLowerCase());
    }

    default public String format() {
        String display = this.name();
        String valueFormat = this.inputType() == null ? "" : " <value>";
        return StringUtils.normalizedParameterFormatting("-" + display + valueFormat, true);
    }

    default public boolean acceptsInput(String input) {
        input = input.substring(Patterns.isDoubleFlag(input) ? 2 : (Patterns.isSingleFlag(input) ? 1 : 0));
        return this.name().equalsIgnoreCase(input) || this.hasAlias(input);
    }

    default public boolean isSwitch() {
        return this.inputType() == null;
    }

    public record FlagDataImpl<S extends Source>(String name, List<String> aliases, ParameterType<S, ?> inputType, boolean free) implements FlagData<S>
    {
        @Override
        public boolean isFree() {
            return this.free;
        }
    }
}

