/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context;

import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandFlag;
import dev.velix.imperat.exception.ImperatException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="1.0.0")
public interface ExecutionContext<S extends Source>
extends Context<S> {
    public Optional<CommandFlag> getFlag(String var1);

    @Nullable
    public <T> T getFlagValue(String var1);

    @Nullable
    public <T> T getArgument(String var1);

    @NotNull
    default public <T> T getArgumentOr(String name, T value) {
        T argValue = this.getArgument(name);
        if (argValue != null) {
            return argValue;
        }
        return value;
    }

    default public String getRawArgument(int index) {
        if (index >= this.arguments().size() || index < 0) {
            return null;
        }
        return (String)this.arguments().get(index);
    }

    @NotNull
    public <R> R getResolvedSource(Type var1) throws ImperatException;

    @Nullable
    public <T> T getContextResolvedArgument(Class<T> var1) throws ImperatException;

    public Collection<? extends CommandFlag> getResolvedFlags();
}

