/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.context;

import dev.velix.imperat.context.ArgumentQueueImpl;
import dev.velix.imperat.util.StringUtils;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.AvailableSince(value="1.0.0")
public interface ArgumentQueue
extends Deque<String>,
List<String>,
Cloneable {
    public static ArgumentQueue parse(String[] rawArguments) {
        return StringUtils.parseToQueue(String.join((CharSequence)" ", rawArguments), false);
    }

    public static ArgumentQueue parse(String string) {
        return StringUtils.parseToQueue(string, false);
    }

    public static ArgumentQueue parseAutoCompletion(String[] argumentsOnly, boolean extraLastSpace) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < argumentsOnly.length; ++i) {
            String arg = argumentsOnly[i];
            builder.append(arg);
            if (!extraLastSpace) {
                if (i == argumentsOnly.length - 1) continue;
                builder.append(" ");
                continue;
            }
            builder.append(" ");
        }
        return ArgumentQueue.parseAutoCompletion(builder.toString(), extraLastSpace);
    }

    public static ArgumentQueue parseAutoCompletion(String string, boolean extraLastSpace) {
        if (string.isEmpty()) {
            return StringUtils.parseToQueue("", true);
        }
        return StringUtils.parseToQueue(string, true, extraLastSpace);
    }

    public static ArgumentQueue of(String originalLine) {
        return new ArgumentQueueImpl(originalLine, new String[0]);
    }

    public static ArgumentQueue empty() {
        return new ArgumentQueueImpl();
    }

    public String getOriginalRaw();

    @Nullable
    default public String getOr(int index, @Nullable String def) {
        if (index < 0 || index >= this.size()) {
            return def;
        }
        return (String)this.get(index);
    }

    @NotNull
    public String join(String var1);

    @NotNull
    public String join(@NotNull String var1, int var2);

    @NotNull
    public @UnmodifiableView List<String> asImmutableView();

    @NotNull
    public @Unmodifiable List<String> asImmutableCopy();

    @NotNull
    public ArgumentQueue copy();
}

