/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.tree;

import dev.velix.imperat.command.tree.CommandTree;
import dev.velix.imperat.command.tree.ParameterNode;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.ImperatDebugger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CommandTreeVisualizer<S extends Source> {
    @Nullable
    private final CommandTree<S> tree;

    CommandTreeVisualizer(@Nullable CommandTree<S> tree) {
        this.tree = tree;
    }

    public static <S extends Source> CommandTreeVisualizer<S> of(@Nullable CommandTree<S> tree) {
        return new CommandTreeVisualizer<S>(tree);
    }

    public void visualize() {
        if (this.tree == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.visualizeNode(this.tree.root, builder, 0);
        ImperatDebugger.debug(builder.toString(), new Object[0]);
    }

    private void visualizeNode(ParameterNode<S, ?> node, StringBuilder builder, int depth) {
        if (node == null) {
            return;
        }
        builder.append("  ".repeat(Math.max(0, depth)));
        builder.append(node.format()).append("\n");
        for (ParameterNode<S, ?> child : node.getChildren()) {
            this.visualizeNode(child, builder, depth + 1);
        }
    }
}

