/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.tree;

import dev.velix.imperat.command.Command;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.command.tree.ParameterNode;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.util.ImperatDebugger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandDispatch<S extends Source>
implements Iterable<CommandParameter<S>> {
    private final List<CommandParameter<S>> parameters = new ArrayList<CommandParameter<S>>();
    private Result result;

    private CommandDispatch(Result result) {
        this.result = result;
    }

    static <S extends Source> CommandDispatch<S> of(Result result) {
        return new CommandDispatch<S>(result);
    }

    static <S extends Source> CommandDispatch<S> unknown() {
        return CommandDispatch.of(Result.UNKNOWN);
    }

    static <S extends Source> CommandDispatch<S> incomplete() {
        return CommandDispatch.of(Result.INCOMPLETE);
    }

    public void append(ParameterNode<S, ?> node) {
        if (node == null) {
            return;
        }
        this.parameters.add((CommandParameter<S>)node.data);
    }

    public void append(CommandParameter<S> parameter) {
        if (parameter == null) {
            return;
        }
        this.parameters.add(parameter);
    }

    public CommandParameter<S> getLastParameter() {
        return this.parameters.get(this.parameters.size() - 1);
    }

    @Override
    @NotNull
    public Iterator<CommandParameter<S>> iterator() {
        return this.parameters.iterator();
    }

    public Result result() {
        return this.result;
    }

    public void result(Result result) {
        this.result = result;
    }

    @Nullable
    public CommandUsage<S> toUsage(Command<S> command) {
        return command.getUsage(this.parameters);
    }

    @NotNull
    public CommandDispatch<S> copy() {
        CommandDispatch<S> commandDispatch = CommandDispatch.of(this.result);
        this.parameters.forEach(commandDispatch::append);
        return commandDispatch;
    }

    public void visualize() {
        ImperatDebugger.debug("Result => " + this.result.name(), new Object[0]);
        StringBuilder builder = new StringBuilder();
        int size = this.parameters.size();
        int i = 0;
        for (CommandParameter<S> node : this.parameters) {
            builder.append(node.format());
            if (i != size - 1) {
                builder.append(" -> ");
            }
            ++i;
        }
        ImperatDebugger.debug(builder.toString(), new Object[0]);
    }

    public static enum Result {
        COMPLETE,
        INCOMPLETE,
        UNKNOWN;

    }
}

