/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.processors.impl;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.cooldown.CooldownHandler;
import dev.velix.imperat.command.cooldown.UsageCooldown;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.context.Context;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.exception.CooldownException;
import dev.velix.imperat.exception.ImperatException;

public final class UsageCooldownProcessor<S extends Source>
implements CommandPreProcessor<S> {
    UsageCooldownProcessor() {
    }

    @Override
    public void process(Imperat<S> imperat, Context<S> context, CommandUsage<S> usage) throws ImperatException {
        S source = context.source();
        CooldownHandler<S> handler = usage.getCooldownHandler();
        UsageCooldown cooldown = usage.getCooldown();
        if (handler.hasCooldown(source)) {
            assert (cooldown != null);
            if (cooldown.permission() == null || cooldown.permission().isEmpty() || !imperat.config().getPermissionResolver().hasPermission(source, cooldown.permission())) {
                throw new CooldownException(cooldown.toMillis(), handler.getLastTimeExecuted(source).orElse(0L));
            }
        }
        handler.registerExecutionMoment(source);
    }
}

