/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.processors;

import dev.velix.imperat.command.processors.ChainImpl;
import dev.velix.imperat.command.processors.CommandPostProcessor;
import dev.velix.imperat.command.processors.CommandPreProcessor;
import dev.velix.imperat.command.processors.CommandProcessor;
import dev.velix.imperat.context.Source;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public interface CommandProcessingChain<S extends Source, P extends CommandProcessor>
extends Iterable<P> {
    @NotNull
    public Queue<P> getProcessors();

    public void reset();

    public void add(P var1);

    public static <S extends Source> Builder<S, CommandPreProcessor<S>> preProcessors() {
        return new Builder();
    }

    public static <S extends Source> Builder<S, CommandPostProcessor<S>> postProcessors() {
        return new Builder();
    }

    public static final class Builder<S extends Source, P extends CommandProcessor> {
        private final PriorityQueue<P> processors = new PriorityQueue((p1, p2) -> Integer.compare(p1.priority(), p2.priority()));

        public Builder<S, P> then(P processor) {
            this.processors.offer(processor);
            return this;
        }

        public CommandProcessingChain<S, P> build() {
            return new ChainImpl(this.processors);
        }
    }
}

