/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.CommandParameter;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.util.TypeUtility;
import dev.velix.imperat.util.TypeWrap;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ParameterType<S extends Source, T> {
    public Type type();

    @Nullable
    default public T resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> inputStream) throws ImperatException {
        return this.fromString(context.imperat(), inputStream.readInput());
    }

    public SuggestionResolver<S> getSuggestionResolver();

    public boolean matchesInput(String var1, CommandParameter<S> var2);

    default public boolean isRelatedToType(Type type) {
        return TypeUtility.areRelatedTypes(type, this.type());
    }

    default public boolean equalsExactly(Type type) {
        return TypeUtility.matches(type, this.type());
    }

    @NotNull
    public ParameterType<S, T> withSuggestions(String ... var1);

    default public TypeWrap<T> wrappedType() {
        return TypeWrap.of(this.type());
    }

    @Nullable
    public T fromString(Imperat<S> var1, String var2) throws ImperatException;
}

