/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.exception.SourceException;
import dev.velix.imperat.util.TypeWrap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapParameterType<S extends Source, K, V, M extends Map<K, V>>
extends BaseParameterType<S, M> {
    private static final String ENTRY_SEPARATOR = ",";
    private final Supplier<M> mapInitializer;
    private final ParameterType<S, K> keyResolver;
    private final ParameterType<S, V> valueResolver;

    public MapParameterType(TypeWrap<M> type, Supplier<M> mapInitializer, ParameterType<S, K> keyResolver, ParameterType<S, V> valueResolver) {
        super(type);
        this.mapInitializer = mapInitializer;
        this.keyResolver = keyResolver;
        this.valueResolver = valueResolver;
    }

    @Override
    @Nullable
    public M resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        String raw;
        Map newMap = (Map)this.mapInitializer.get();
        while (commandInputStream.hasNextRaw() && (raw = (String)commandInputStream.currentRaw().orElse(null)) != null) {
            if (!raw.contains(ENTRY_SEPARATOR)) {
                throw new SourceException("Invalid map entry '%s', entry doesn't contain '%s'", raw, ENTRY_SEPARATOR);
            }
            String[] split = raw.split(ENTRY_SEPARATOR);
            if (split.length != 2) {
                throw new SourceException("Invalid map entry '%s', entry is not made of 2 elements", raw);
            }
            String keyRaw = split[0];
            String valueRaw = split[1];
            K key = this.keyResolver.fromString(context.imperat(), keyRaw);
            V value = this.valueResolver.fromString(context.imperat(), valueRaw);
            newMap.put(key, value);
            commandInputStream.skipRaw();
        }
        return (M)newMap;
    }

    @Override
    @NotNull
    public M fromString(Imperat<S> imperat, String input) throws ImperatException {
        String[] args = input.split(" ");
        Map newMap = (Map)this.mapInitializer.get();
        for (String raw : args) {
            String[] split = raw.split(ENTRY_SEPARATOR);
            if (split.length != 2) continue;
            String keyRaw = split[0];
            String valueRaw = split[1];
            K key = this.keyResolver.fromString(imperat, keyRaw);
            V value = this.valueResolver.fromString(imperat, valueRaw);
            newMap.put(key, value);
        }
        return (M)newMap;
    }
}

