/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters.type;

import dev.velix.imperat.Imperat;
import dev.velix.imperat.command.parameters.type.BaseParameterType;
import dev.velix.imperat.command.parameters.type.ParameterType;
import dev.velix.imperat.context.ExecutionContext;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandInputStream;
import dev.velix.imperat.exception.ImperatException;
import dev.velix.imperat.util.TypeWrap;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionParameterType<S extends Source, E, C extends Collection<E>>
extends BaseParameterType<S, C> {
    private final Supplier<C> collectionSupplier;
    private final ParameterType<S, E> componentResolver;

    public CollectionParameterType(TypeWrap<C> type, Supplier<C> collectionSupplier, ParameterType<S, E> componentResolver) {
        super(type);
        this.collectionSupplier = collectionSupplier;
        this.componentResolver = componentResolver;
    }

    @Override
    @Nullable
    public C resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream) throws ImperatException {
        String raw;
        Collection newCollection = (Collection)this.collectionSupplier.get();
        while (commandInputStream.hasNextRaw() && (raw = (String)commandInputStream.currentRaw().orElse(null)) != null) {
            E element = this.componentResolver.resolve(context, commandInputStream);
            newCollection.add(element);
            commandInputStream.skipRaw();
        }
        return (C)newCollection;
    }

    @Override
    @NotNull
    public C fromString(Imperat<S> imperat, String input) throws ImperatException {
        String[] split = input.split(" ");
        Collection newCollection = (Collection)this.collectionSupplier.get();
        for (String raw : split) {
            E element = this.componentResolver.fromString(imperat, raw);
            newCollection.add(element);
        }
        return (C)newCollection;
    }
}

