/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.parameters;

import dev.velix.imperat.command.Description;
import dev.velix.imperat.command.parameters.FlagParameter;
import dev.velix.imperat.command.parameters.InputParameter;
import dev.velix.imperat.command.parameters.type.ParameterTypes;
import dev.velix.imperat.context.FlagData;
import dev.velix.imperat.context.Source;
import dev.velix.imperat.context.internal.CommandFlag;
import dev.velix.imperat.resolvers.SuggestionResolver;
import dev.velix.imperat.supplier.OptionalValueSupplier;
import dev.velix.imperat.util.TypeWrap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FlagCommandParameter<S extends Source>
extends InputParameter<S>
implements FlagParameter<S> {
    private final FlagData<S> flag;
    private final OptionalValueSupplier<?> inputValueSupplier;
    private final SuggestionResolver<S> inputValueSuggestionResolver;

    FlagCommandParameter(FlagData<S> flag, String permission, Description description, OptionalValueSupplier<?> inputValueSupplier, SuggestionResolver<S> inputValueSuggestionResolver) {
        super(flag.name(), ParameterTypes.flag(flag), permission, description, true, true, false, OptionalValueSupplier.empty(TypeWrap.of(CommandFlag.class)), inputValueSuggestionResolver);
        this.flag = flag;
        this.inputValueSupplier = inputValueSupplier;
        this.inputValueSuggestionResolver = inputValueSuggestionResolver;
    }

    @Override
    public String format() {
        return this.flag.format();
    }

    @Override
    @NotNull
    public FlagData<S> flagData() {
        return this.flag;
    }

    @Override
    @NotNull
    public <T> OptionalValueSupplier<T> getDefaultValueSupplier() {
        return this.inputValueSupplier;
    }

    @Override
    @Nullable
    public SuggestionResolver<S> inputSuggestionResolver() {
        if (this.isSwitch()) {
            return null;
        }
        return this.inputValueSuggestionResolver;
    }
}

