/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.cooldown;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.cooldown.CooldownHandler;
import dev.velix.imperat.command.cooldown.UsageCooldown;
import dev.velix.imperat.context.Source;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class DefaultCooldownHandler<S extends Source>
implements CooldownHandler<S> {
    private final Map<String, Long> lastTimeExecuted = new HashMap<String, Long>();
    private final CommandUsage<S> usage;

    DefaultCooldownHandler(CommandUsage<S> usage) {
        this.usage = usage;
    }

    @Override
    public void registerExecutionMoment(S source) {
        this.lastTimeExecuted.put(source.name(), System.currentTimeMillis());
    }

    @Override
    public Optional<UsageCooldown> getUsageCooldown() {
        return Optional.ofNullable(this.usage.getCooldown());
    }

    @Override
    public void removeCooldown(S source) {
        this.lastTimeExecuted.remove(source.name());
    }

    @Override
    public Optional<Long> getLastTimeExecuted(S source) {
        return Optional.ofNullable(this.lastTimeExecuted.get(source.name()));
    }
}

