/*
 * Decompiled with CFR 0.152.
 */
package dev.velix.imperat.command.cooldown;

import dev.velix.imperat.command.CommandUsage;
import dev.velix.imperat.command.cooldown.DefaultCooldownHandler;
import dev.velix.imperat.command.cooldown.UsageCooldown;
import dev.velix.imperat.context.Source;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public interface CooldownHandler<S extends Source> {
    public void registerExecutionMoment(S var1);

    public Optional<UsageCooldown> getUsageCooldown();

    default public boolean hasCooldown(S source) {
        UsageCooldown usageCooldown = this.getUsageCooldown().orElse(null);
        if (usageCooldown == null) {
            return false;
        }
        boolean result = this.getLastTimeExecuted(source).map(lastTime -> {
            long timePassed = System.currentTimeMillis() - lastTime;
            return timePassed <= usageCooldown.toMillis();
        }).orElse(false);
        if (!result) {
            this.removeCooldown(source);
        }
        return result;
    }

    public void removeCooldown(S var1);

    public Optional<Long> getLastTimeExecuted(S var1);

    public static <S extends Source> CooldownHandler<S> createDefault(CommandUsage<S> usage) {
        return new DefaultCooldownHandler<S>(usage);
    }
}

